/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.ModuleNameType;
import org.drools.guvnor.server.security.ModuleUUIDType;
import org.drools.guvnor.server.security.RoleType;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.jboss.seam.security.Identity;

@ApplicationScoped
public class ServiceSecurity {
    @Inject
    private Identity identity;

    protected void checkSecurityIsAdmin() {
        this.identity.checkPermission((Object)new AdminType(), RoleType.ADMIN.getName());
    }

    protected boolean isSecurityIsAnalystReadWithTargetObject(Object target) {
        return this.identity.hasPermission(target, RoleType.ANALYST_READ.getName());
    }

    protected void checkPermissionAnalystReadWithCategoryPathType(String categoryPath) {
        this.identity.checkPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName());
    }

    protected boolean hasPermissionAnalystReadWithCategoryPathType(String categoryPath) {
        return this.identity.hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName());
    }

    protected void checkSecurityIsPackageAdminWithPackageName(String packageName) {
        this.identity.checkPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_ADMIN.getName());
    }

    protected void checkSecurityIsPackageAdminWithAdminType() {
        this.identity.checkPermission((Object)new AdminType(), RoleType.PACKAGE_ADMIN.getName());
    }

    protected void checkSecurityIsPackageAdminWithPackageUuid(String uuid) {
        this.identity.checkPermission((Object)new ModuleUUIDType(uuid), RoleType.PACKAGE_ADMIN.getName());
    }

    protected void checkSecurityIsPackageDeveloperWithPackageUuid(String uuid) {
        this.identity.checkPermission((Object)new ModuleUUIDType(uuid), RoleType.PACKAGE_DEVELOPER.getName());
    }

    protected void checkSecurityIsPackageDeveloperWithPackageName(String packageName) {
        this.identity.checkPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_DEVELOPER.getName());
    }

    protected void checkSecurityIsPackageReadOnlyWithPackageName(String packageName) {
        this.identity.checkPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_READONLY.getName());
    }

    protected void checkSecurityPackageReadOnlyWithPackageUuid(String uuid) {
        this.identity.checkPermission((Object)new ModuleUUIDType(uuid), RoleType.PACKAGE_READONLY.getName());
    }

    protected void checkIsPackageDeveloperOrAnalyst(Asset asset) {
        block6: {
            boolean passed = false;
            try {
                this.identity.checkPermission((Object)new ModuleNameType(asset.getMetaData().getModuleName()), RoleType.PACKAGE_DEVELOPER.getName());
            }
            catch (RuntimeException e) {
                if (asset.getMetaData().getCategories().length == 0) {
                    this.identity.checkPermission((Object)new CategoryPathType(null), RoleType.ANALYST.getName());
                }
                RuntimeException exception = null;
                for (String cat : asset.getMetaData().getCategories()) {
                    try {
                        this.identity.checkPermission((Object)new CategoryPathType(cat), RoleType.ANALYST.getName());
                        passed = true;
                    }
                    catch (RuntimeException re) {
                        exception = re;
                    }
                }
                if (passed) break block6;
                throw exception;
            }
        }
    }

    protected void checkIsPackageDeveloperOrAnalyst(AssetItem asset) {
        block6: {
            boolean passed = false;
            try {
                this.identity.checkPermission((Object)new ModuleUUIDType(asset.getModule().getUUID()), RoleType.PACKAGE_DEVELOPER.getName());
            }
            catch (RuntimeException e) {
                if (asset.getCategories().size() == 0) {
                    this.identity.checkPermission((Object)new CategoryPathType(null), RoleType.ANALYST.getName());
                }
                RuntimeException exception = null;
                for (CategoryItem cat : asset.getCategories()) {
                    try {
                        this.identity.checkPermission((Object)new CategoryPathType(cat.getFullPath()), RoleType.ANALYST.getName());
                        passed = true;
                    }
                    catch (RuntimeException re) {
                        exception = re;
                    }
                }
                if (passed) break block6;
                throw exception;
            }
        }
    }

    protected void checkIsPackageReadOnlyOrAnalystReadOnly(Asset asset) {
        block6: {
            boolean passed = false;
            try {
                this.identity.checkPermission((Object)new ModuleNameType(asset.getMetaData().getModuleName()), RoleType.PACKAGE_READONLY.getName());
            }
            catch (RuntimeException e) {
                if (asset.getMetaData().getCategories().length == 0) {
                    this.identity.checkPermission((Object)new CategoryPathType(null), RoleType.ANALYST_READ.getName());
                }
                RuntimeException exception = null;
                for (String cat : asset.getMetaData().getCategories()) {
                    try {
                        this.identity.checkPermission((Object)new CategoryPathType(cat), RoleType.ANALYST_READ.getName());
                        passed = true;
                    }
                    catch (RuntimeException re) {
                        exception = re;
                    }
                }
                if (passed) break block6;
                throw exception;
            }
        }
    }
}

