/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.guvnor.server.builder.ModuleAssemblerConfiguration;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.repository.ModuleItem;
import org.drools.repository.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleAssemblerManager {
    private static final Logger log = LoggerFactory.getLogger(ContentManager.class);
    private static final String CONTENT_CONFIG_PROPERTIES = "/moduleassembler.properties";
    private static ModuleAssemblerManager INSTANCE;
    private final Map<String, String> moduleAssemblers = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleAssemblerManager(String configPath) {
        log.debug("Loading ModuleAssembler properties");
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(configPath);
            props.load(in);
            for (Object o : props.keySet()) {
                String moduleFormat = (String)o;
                String moduleAssemblerClassName = props.getProperty(moduleFormat);
                this.moduleAssemblers.put(moduleFormat, moduleAssemblerClassName);
            }
        }
        catch (IOException e) {
            try {
                log.error("UNABLE to load ModuleAssembler. Ahem, nothing will actually work. Ignore subsequent errors until this is resolved.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public Map<String, String> getModuleAssemblers() {
        return this.moduleAssemblers;
    }

    private static ModuleAssembler loadModuleAssemblerImplementation(String val) throws IOException {
        try {
            return (ModuleAssembler)Thread.currentThread().getContextClassLoader().loadClass(val).newInstance();
        }
        catch (InstantiationException e) {
            log.error("Unable to load ModuleAssembler implementation.", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error("Unable to load ModuleAssembler implementation.", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load ModuleAssembler implementation.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModuleAssemblerManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ModuleAssemblerManager> clazz = ModuleAssemblerManager.class;
        synchronized (ModuleAssemblerManager.class) {
            INSTANCE = new ModuleAssemblerManager(CONTENT_CONFIG_PROPERTIES);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static ModuleAssembler getModuleAssembler(String format, ModuleItem moduleItem, ModuleAssemblerConfiguration moduleAssemblerConfiguration) {
        String moduleAssemblerClassName = ModuleAssemblerManager.getInstance().getModuleAssemblers().get(format);
        if (moduleAssemblerClassName == null) {
            throw new IllegalArgumentException("Unable to handle the module type: " + format);
        }
        ModuleAssembler moduleAssembler = null;
        try {
            moduleAssembler = ModuleAssemblerManager.loadModuleAssemblerImplementation(moduleAssemblerClassName);
            moduleAssembler.init(moduleItem, moduleAssemblerConfiguration);
        }
        catch (IOException e) {
            log.error("UNABLE to load ModuleAssembler. Ahem, nothing will actually work. Ignore subsequent errors until this is resolved.", (Throwable)e);
        }
        return moduleAssembler;
    }
}

