/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.guvnor.server.util.AssetPageRowPopulator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.jboss.seam.security.Identity;

public class AssetPageRowBuilder
implements PageRowBuilder<PageRequest, AssetItemIterator> {
    private PageRequest pageRequest;
    private AssetItemIterator iterator;
    private Identity identity;

    @Override
    public List<AssetPageRow> build() {
        this.validate();
        Integer pageSize = this.pageRequest.getPageSize();
        this.iterator.skip((long)this.pageRequest.getStartRowIndex());
        ArrayList<AssetPageRow> rowList = new ArrayList<AssetPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = this.iterator.next();
            AssetPageRowPopulator assetPageRowPopulator = new AssetPageRowPopulator();
            rowList.add(assetPageRowPopulator.populateFrom(assetItem));
        }
        return rowList;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public AssetPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public AssetPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public AssetPageRowBuilder withContent(AssetItemIterator iterator) {
        this.iterator = iterator;
        return this;
    }
}

