/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.RuleBasedSelector;
import org.drools.repository.AssetItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorManager {
    private static final Logger log = LoggerFactory.getLogger(SelectorManager.class);
    private static final String SELECTOR_CONFIG_PROPERTIES = "selectors.properties";
    private static final SelectorManager INSTANCE = new SelectorManager("selectors.properties");
    public static final String BUILT_IN_SELECTOR = "BuiltInSelector";
    public static final String CUSTOM_SELECTOR = "customSelector";
    public final Map<String, AssetSelector> selectors = new HashMap<String, AssetSelector>();

    SelectorManager(String configPath) {
        log.debug("Loading selectors");
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(configPath));
            props.put(BUILT_IN_SELECTOR, "org.drools.guvnor.server.selector.BuiltInSelector");
            for (Object o : props.keySet()) {
                String selectorName = (String)o;
                String val = props.getProperty(selectorName);
                this.detemineSelector(selectorName, val);
            }
        }
        catch (IOException e) {
            log.error("Unable to load selectors.", (Throwable)e);
        }
    }

    private void detemineSelector(String selectorName, String val) {
        try {
            if (val.endsWith("drl")) {
                this.selectors.put(selectorName, this.loadRuleSelector(val));
            } else {
                this.selectors.put(selectorName, this.loadSelectorImplementation(val));
            }
        }
        catch (Exception e) {
            log.error("Unable to load a selector [" + val + "]", (Throwable)e);
        }
    }

    public AssetSelector getSelector(String name) {
        if (name == null || "".equals(name.trim())) {
            return this.nilSelector();
        }
        if (this.selectors.containsKey(name)) {
            return this.selectors.get(name);
        }
        log.debug("No selector found by the name of " + name);
        return null;
    }

    public String[] getCustomSelectors() {
        Set<String> s = this.selectors.keySet();
        ArrayList<String> selectorList = new ArrayList<String>();
        selectorList.addAll(s);
        selectorList.remove(BUILT_IN_SELECTOR);
        String[] result = new String[selectorList.size()];
        return selectorList.toArray(result);
    }

    private AssetSelector nilSelector() {
        return new AssetSelector(){

            @Override
            public boolean isAssetAllowed(AssetItem asset) {
                return true;
            }
        };
    }

    private AssetSelector loadSelectorImplementation(String val) throws Exception {
        Class<?> assetEditorClass = null;
        try {
            assetEditorClass = Thread.currentThread().getContextClassLoader().loadClass(val);
        }
        catch (ClassNotFoundException e) {
            assetEditorClass = this.getClass().getClassLoader().loadClass(val);
        }
        return (AssetSelector)assetEditorClass.newInstance();
    }

    private AssetSelector loadRuleSelector(String val) {
        return new RuleBasedSelector(val);
    }

    public static SelectorManager getInstance() {
        return INSTANCE;
    }
}

