/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class JmxDumper
implements NotificationListener {
    public static final String help = "help";
    public static final String domain = "domain";
    public static final String fields = "fields";
    public static final String pattern = "pattern";
    public static final String operations = "operations";
    public static final String period = "period";
    public static final String className = "className";
    public static final String outputFile = "outputFile";
    public static final String jmxUrl = "jmxUrl";
    public static final String sampleCount = "sampleCount";
    private static final Logger _logger = Logger.getLogger(JmxDumper.class);
    String _domain;
    MBeanServerConnection _mbeanServer;
    String _beanClassName;
    String _namePattern;
    int _samplePeriod;
    Map<ObjectName, ObjectName> _mbeanNames = new ConcurrentHashMap<ObjectName, ObjectName>();
    Timer _timer;
    String _outputFileName;
    List<String> _outputFields = new ArrayList<String>();
    Set<String> _operations = new HashSet<String>();
    PrintWriter _outputFile;
    int _samples = 0;
    int _targetSamples = -1;
    String _jmxUrl;

    public JmxDumper(String jmxService, String domain, String beanClassName, String namePattern, int samplePeriod, List<String> fields, List<String> operations, String outputfile, int sampleCount) throws Exception {
        this._jmxUrl = jmxService;
        this._domain = domain;
        this._beanClassName = beanClassName;
        this._samplePeriod = samplePeriod;
        this._outputFields.addAll(fields);
        this._operations.addAll(operations);
        this._outputFileName = outputfile;
        this._namePattern = namePattern;
        this._targetSamples = sampleCount;
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this._jmxUrl + "/jmxrmi");
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        this._mbeanServer = jmxc.getMBeanServerConnection();
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        filter.enableAllObjectNames();
        this._mbeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)filter, null);
        this.init();
        this._timer = new Timer(true);
        this._timer.scheduleAtFixedRate((TimerTask)new SampleTask(), this._samplePeriod, (long)this._samplePeriod);
    }

    void init() throws Exception {
        try {
            Set<ObjectInstance> existingInstances = this._mbeanServer.queryMBeans(new ObjectName(this._namePattern), null);
            _logger.info((Object)("Total " + existingInstances.size() + " mbeans matched " + this._namePattern));
            for (ObjectInstance instance : existingInstances) {
                if (!instance.getClassName().equals(this._beanClassName)) continue;
                this._mbeanNames.put(instance.getObjectName(), instance.getObjectName());
                _logger.info((Object)("Sampling " + instance.getObjectName()));
            }
            FileWriter fos = new FileWriter(this._outputFileName);
            System.out.println(this._outputFileName);
            this._outputFile = new PrintWriter(fos);
        }
        catch (Exception e) {
            _logger.error((Object)("fail to get all existing mbeans in " + this._domain), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        MBeanServerNotification mbs = (MBeanServerNotification)notification;
        if ("JMX.mbean.registered".equals(mbs.getType())) {
            _logger.info((Object)("Adding mbean " + mbs.getMBeanName()));
            if (mbs.getMBeanName().getDomain().equalsIgnoreCase(this._domain)) {
                this.addMBean(mbs.getMBeanName());
            }
        } else if ("JMX.mbean.unregistered".equals(mbs.getType())) {
            _logger.info((Object)("Removing mbean " + mbs.getMBeanName()));
            if (mbs.getMBeanName().getDomain().equalsIgnoreCase(this._domain)) {
                this.removeMBean(mbs.getMBeanName());
            }
        }
    }

    private void addMBean(ObjectName beanName) {
        this._mbeanNames.put(beanName, beanName);
    }

    private void removeMBean(ObjectName beanName) {
        this._mbeanNames.remove(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = JmxDumper.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            JmxDumper.printUsage(cliOptions);
            System.exit(1);
        }
        boolean ret = JmxDumper.checkOptionArgsNumber(cmd.getOptions());
        if (!ret) {
            JmxDumper.printUsage(cliOptions);
            System.exit(1);
        }
        String portStr = cmd.getOptionValue(jmxUrl);
        String periodStr = cmd.getOptionValue(period);
        int periodVal = Integer.parseInt(periodStr);
        String domainStr = cmd.getOptionValue(domain);
        String classNameStr = cmd.getOptionValue(className);
        String patternStr = cmd.getOptionValue(pattern);
        String fieldsStr = cmd.getOptionValue(fields);
        String operationsStr = cmd.getOptionValue(operations);
        String resultFile = cmd.getOptionValue(outputFile);
        String sampleCountStr = cmd.getOptionValue(sampleCount, "-1");
        int sampleCount = Integer.parseInt(sampleCountStr);
        List<String> fields = Arrays.asList(fieldsStr.split(","));
        List<String> operations = Arrays.asList(operationsStr.split(","));
        JmxDumper dumper = null;
        try {
            JmxDumper jmxDumper = dumper = new JmxDumper(portStr, domainStr, classNameStr, patternStr, periodVal, fields, operations, resultFile, sampleCount);
            synchronized (jmxDumper) {
                dumper.wait();
            }
            if (dumper != null) {
                dumper.flushFile();
            }
        }
        catch (Throwable throwable) {
            if (dumper != null) {
                super.flushFile();
            }
            throw throwable;
        }
        return 0;
    }

    private void flushFile() {
        if (this._outputFile != null) {
            this._outputFile.flush();
            this._outputFile.close();
        }
    }

    private static boolean checkOptionArgsNumber(Option[] options) {
        for (Option option : options) {
            int argNb = option.getArgs();
            Object[] args = option.getValues();
            if (argNb == 0) {
                if (args == null || args.length <= 0) continue;
                System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
                return false;
            }
            if (args != null && args.length == argNb) continue;
            System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
            return false;
        }
        return true;
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)domain);
        OptionBuilder.withDescription((String)"Domain of the JMX bean");
        Option domainOption = OptionBuilder.create();
        domainOption.setArgs(1);
        domainOption.setRequired(true);
        OptionBuilder.withLongOpt((String)fields);
        OptionBuilder.withDescription((String)"Fields of the JMX bean to sample");
        Option fieldsOption = OptionBuilder.create();
        fieldsOption.setArgs(1);
        fieldsOption.setRequired(false);
        OptionBuilder.withLongOpt((String)operations);
        OptionBuilder.withDescription((String)"Operation to invoke");
        Option operationOption = OptionBuilder.create();
        operationOption.setArgs(1);
        operationOption.setRequired(true);
        OptionBuilder.withLongOpt((String)period);
        OptionBuilder.withDescription((String)"Sampling period in MS");
        Option periodOption = OptionBuilder.create();
        periodOption.setArgs(1);
        periodOption.setRequired(false);
        OptionBuilder.withLongOpt((String)className);
        OptionBuilder.withDescription((String)"Classname of the MBean");
        Option classOption = OptionBuilder.create();
        classOption.setArgs(1);
        classOption.setRequired(true);
        OptionBuilder.withLongOpt((String)pattern);
        OptionBuilder.withDescription((String)"pattern of the MBean");
        Option patternOption = OptionBuilder.create();
        patternOption.setArgs(1);
        patternOption.setRequired(true);
        OptionBuilder.withLongOpt((String)outputFile);
        OptionBuilder.withDescription((String)"outputFileName");
        Option outputFileOption = OptionBuilder.create();
        outputFileOption.setArgs(1);
        outputFileOption.setRequired(false);
        OptionBuilder.withLongOpt((String)jmxUrl);
        OptionBuilder.withDescription((String)"jmx port to connect to");
        Option jmxUrlOption = OptionBuilder.create();
        jmxUrlOption.setArgs(1);
        jmxUrlOption.setRequired(true);
        OptionBuilder.withLongOpt((String)sampleCount);
        OptionBuilder.withDescription((String)"# of samples to take");
        Option sampleCountOption = OptionBuilder.create();
        sampleCountOption.setArgs(1);
        sampleCountOption.setRequired(false);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(domainOption);
        options.addOption(fieldsOption);
        options.addOption(operationOption);
        options.addOption(classOption);
        options.addOption(outputFileOption);
        options.addOption(jmxUrlOption);
        options.addOption(patternOption);
        options.addOption(periodOption);
        options.addOption(sampleCountOption);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + JmxDumper.class.getName(), cliOptions);
    }

    public static void main(String[] args) throws Exception {
        int ret = JmxDumper.processCommandLineArgs(args);
        System.exit(ret);
    }

    class SampleTask
    extends TimerTask {
        SampleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<ObjectName> errorMBeans = new ArrayList<ObjectName>();
            _logger.info((Object)("Sampling " + JmxDumper.this._mbeanNames.size() + " beans"));
            for (ObjectName beanName : JmxDumper.this._mbeanNames.keySet()) {
                MBeanInfo info;
                try {
                    info = JmxDumper.this._mbeanServer.getMBeanInfo(beanName);
                }
                catch (Exception e) {
                    _logger.error((Object)(e.getMessage() + " removing it"));
                    errorMBeans.add(beanName);
                    continue;
                }
                if (!info.getClassName().equals(JmxDumper.this._beanClassName)) {
                    _logger.warn((Object)("Skip: className " + info.getClassName() + " expected : " + JmxDumper.this._beanClassName));
                    continue;
                }
                StringBuffer line = new StringBuffer();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss:SSS");
                String date = dateFormat.format(new Date());
                line.append(date + " ");
                line.append(beanName.toString() + " ");
                MBeanAttributeInfo[] infos = info.getAttributes();
                HashMap<String, MBeanAttributeInfo> infoMap = new HashMap<String, MBeanAttributeInfo>();
                for (MBeanAttributeInfo infoItem : infos) {
                    infoMap.put(infoItem.getName(), infoItem);
                }
                for (String outputField : JmxDumper.this._outputFields) {
                    try {
                        if (infoMap.containsKey(outputField)) {
                            Object mbeanAttributeValue = JmxDumper.this._mbeanServer.getAttribute(beanName, outputField);
                            line.append(mbeanAttributeValue.toString() + " ");
                            continue;
                        }
                        _logger.warn((Object)(outputField + " not found"));
                        line.append("null ");
                    }
                    catch (Exception e) {
                        _logger.error((Object)"Error:", (Throwable)e);
                        line.append("null ");
                    }
                }
                MBeanOperationInfo[] operations = info.getOperations();
                HashMap<String, MBeanOperationInfo> opeMap = new HashMap<String, MBeanOperationInfo>();
                for (MBeanOperationInfo opeItem : operations) {
                    opeMap.put(opeItem.getName(), opeItem);
                }
                for (String ope : JmxDumper.this._operations) {
                    if (!opeMap.containsKey(ope)) continue;
                    try {
                        JmxDumper.this._mbeanServer.invoke(beanName, ope, new Object[0], new String[0]);
                    }
                    catch (Exception e) {
                        _logger.error((Object)"Error:", (Throwable)e);
                    }
                }
                JmxDumper.this._outputFile.println(line.toString());
            }
            for (ObjectName deadBean : errorMBeans) {
                JmxDumper.this._mbeanNames.remove(deadBean);
            }
            ++JmxDumper.this._samples;
            if (JmxDumper.this._samples == JmxDumper.this._targetSamples) {
                JmxDumper jmxDumper = JmxDumper.this;
                synchronized (jmxDumper) {
                    _logger.info((Object)(JmxDumper.this._samples + " samples done, exiting..."));
                    JmxDumper.this.notifyAll();
                }
            }
        }
    }
}

