/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.RenameHelper;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.RenameRestrictor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class RenameServiceImpl
implements RenameService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Instance<RenameHelper> helpers;
    @Inject
    private Instance<RenameRestrictor> renameRestrictorBeans;

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        LOGGER.info("User:" + this.identity.getIdentifier() + " renaming file [" + path.getFileName() + "] to [" + newName + "]");
        this.checkRestrictions(path);
        try {
            return this.renamePath(path, newName, comment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void renameIfExists(Collection<org.uberfire.backend.vfs.Path> paths, String newName, String comment) {
        try {
            this.startBatch(paths);
            for (org.uberfire.backend.vfs.Path path : paths) {
                LOGGER.info("User:" + this.identity.getIdentifier() + " renaming file (if exists) [" + path.getFileName() + "] to [" + newName + "]");
                this.checkRestrictions(path);
                this.renamePathIfExists(path, newName, comment);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch();
        }
    }

    public boolean hasRestriction(org.uberfire.backend.vfs.Path path) {
        for (RenameRestrictor renameRestrictor : this.getRenameRestrictors()) {
            PathOperationRestriction renameRestriction = renameRestrictor.hasRestriction(path);
            if (renameRestriction == null) continue;
            return true;
        }
        return false;
    }

    private void checkRestrictions(org.uberfire.backend.vfs.Path path) {
        for (RenameRestrictor renameRestrictor : this.getRenameRestrictors()) {
            PathOperationRestriction renameRestriction = renameRestrictor.hasRestriction(path);
            if (renameRestriction == null) continue;
            throw new RuntimeException(renameRestriction.getMessage(path));
        }
    }

    org.uberfire.backend.vfs.Path renamePath(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        String originalFileName = _path.getFileName().toString();
        String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
        Path _target = _path.resolveSibling(newName + extension);
        org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
        try {
            this.ioService.startBatch(_target.getFileSystem());
            this.ioService.move(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
            for (RenameHelper helper : this.helpers) {
                if (!helper.supports(targetPath)) continue;
                helper.postProcess(path, targetPath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch();
        }
        return Paths.convert((Path)_target);
    }

    void renamePathIfExists(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (Files.exists((Path)_path, (LinkOption[])new LinkOption[0])) {
            Path _target;
            if (Files.isDirectory((Path)_path, (LinkOption[])new LinkOption[0])) {
                _target = _path.resolveSibling(newName);
            } else {
                String originalFileName = _path.getFileName().toString();
                String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
                _target = _path.resolveSibling(newName + extension);
            }
            this.ioService.move(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getIdentifier(), null, comment)});
            if (_target != null) {
                org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
                for (RenameHelper helper : this.helpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
        }
    }

    void startBatch(Collection<org.uberfire.backend.vfs.Path> paths) {
        this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)paths.iterator().next()).getFileSystem());
    }

    void endBatch() {
        this.ioService.endBatch();
    }

    Iterable<RenameRestrictor> getRenameRestrictors() {
        return this.renameRestrictorBeans;
    }
}

