/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.security.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.guvnor.common.services.shared.security.KieWorkbenchFeature;
import org.guvnor.common.services.shared.security.KieWorkbenchFeatureRegistry;
import org.guvnor.common.services.shared.security.KieWorkbenchPolicy;

@ApplicationScoped
public class KieWorkbenchACLImpl
implements KieWorkbenchACL {
    public static final String PREFIX_DESCR = "feature.";
    public static final String PREFIX_CHILDREN = "profile.";
    public static final String PREFIX_ROLES = "roles.";
    private KieWorkbenchFeatureRegistry featureRegistry;
    protected Map<String, Set<String>> grantedFeatures = new HashMap<String, Set<String>>();

    public KieWorkbenchACLImpl() {
    }

    @Inject
    public KieWorkbenchACLImpl(KieWorkbenchFeatureRegistry featureRegistry) {
        this.featureRegistry = featureRegistry;
    }

    public KieWorkbenchFeatureRegistry getFeatureRegistry() {
        return this.featureRegistry;
    }

    public void setFeatureRegistry(KieWorkbenchFeatureRegistry featureRegistry) {
        this.featureRegistry = featureRegistry;
    }

    @Override
    public void grantAccess(String role, String ... featureIds) {
        for (String featureId : featureIds) {
            this.getGrantedRoles(featureId).add(role);
            KieWorkbenchFeature feature = this.featureRegistry.getFeature(featureId);
            if (feature == null || feature.getChildren() == null) continue;
            for (KieWorkbenchFeature child : feature.getChildren()) {
                this.grantAccess(role, child.getId());
            }
        }
    }

    @Override
    public void denyAccess(String role, String ... featureIds) {
        for (String featureId : featureIds) {
            this.getGrantedRoles(featureId).remove(role);
            KieWorkbenchFeature feature = this.featureRegistry.getFeature(featureId);
            if (feature == null || feature.getChildren() == null) continue;
            for (KieWorkbenchFeature child : feature.getChildren()) {
                this.denyAccess(role, child.getId());
            }
        }
    }

    @Override
    public Set<String> getGrantedRoles(String featureId) {
        Set<String> roles = this.grantedFeatures.get(featureId);
        if (roles == null) {
            roles = new HashSet<String>();
            this.grantedFeatures.put(featureId, roles);
        }
        return roles;
    }

    @Override
    public void activatePolicy(KieWorkbenchPolicy policy) {
        if (policy == null) {
            return;
        }
        this.grantedFeatures.clear();
        HashMap<String, String> toDeny = new HashMap<String, String>();
        for (String entry : policy.keySet()) {
            String featureId = this.getFeatureId(entry);
            if (this.featureRegistry.getFeature(featureId) != null) continue;
            this.activateFeature(featureId, policy, toDeny);
        }
        for (String featureId : toDeny.keySet()) {
            this.denyAccess((String)toDeny.get(featureId), featureId);
        }
    }

    protected KieWorkbenchFeature activateFeature(String featureId, KieWorkbenchPolicy policy, Map<String, String> toDeny) {
        String descr = this.getDescription(featureId, policy);
        String[] roles = this.getRoles(featureId, policy);
        String[] children = this.getChildren(featureId, policy);
        KieWorkbenchFeature result = this.featureRegistry.registerFeature(featureId, descr);
        if (children != null) {
            HashSet<String> noChildren = new HashSet<String>();
            for (int i = 0; i < children.length; ++i) {
                String child = children[i].trim();
                if (child.startsWith("!")) {
                    child = child.substring(1);
                    noChildren.add(child);
                    continue;
                }
                result.addChildren(this.activateFeature(child, policy, toDeny));
            }
            for (String child : noChildren) {
                result.removeChildren(this.activateFeature(child, policy, toDeny));
            }
        }
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                String role = roles[i].trim();
                if (role.startsWith("!")) {
                    role = role.substring(1);
                    toDeny.put(result.getId(), role);
                    continue;
                }
                this.grantAccess(role, result.getId());
            }
        }
        return result;
    }

    protected String getFeatureId(String entry) {
        String prefix = this.getPrefix(entry);
        return entry.substring(prefix.length());
    }

    protected String getDescription(String featureId, Map<String, String> policy) {
        return policy.get(PREFIX_DESCR + featureId);
    }

    protected String[] getChildren(String featureId, Map<String, String> policy) {
        String value = policy.get(PREFIX_CHILDREN + featureId);
        if (value == null) {
            return null;
        }
        return value.split(",");
    }

    protected String[] getRoles(String featureId, Map<String, String> policy) {
        String value = policy.get(PREFIX_ROLES + featureId);
        if (value == null) {
            return null;
        }
        return value.split(",");
    }

    protected String getPrefix(String entry) {
        if (entry.startsWith(PREFIX_DESCR)) {
            return PREFIX_DESCR;
        }
        if (entry.startsWith(PREFIX_CHILDREN)) {
            return PREFIX_CHILDREN;
        }
        if (entry.startsWith(PREFIX_ROLES)) {
            return PREFIX_ROLES;
        }
        return "";
    }
}

