/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SshFile {
    public String getAbsolutePath();

    public String getName();

    public Map<Attribute, Object> getAttributes(boolean var1) throws IOException;

    public void setAttributes(Map<Attribute, Object> var1) throws IOException;

    public Object getAttribute(Attribute var1, boolean var2) throws IOException;

    public void setAttribute(Attribute var1, Object var2) throws IOException;

    public String readSymbolicLink() throws IOException;

    public void createSymbolicLink(SshFile var1) throws IOException;

    public String getOwner();

    public boolean isDirectory();

    public boolean isFile();

    public boolean doesExist();

    public boolean isReadable();

    public boolean isWritable();

    public boolean isExecutable();

    public boolean isRemovable();

    public SshFile getParentFile();

    public long getLastModified();

    public boolean setLastModified(long var1);

    public long getSize();

    public boolean mkdir();

    public boolean delete();

    public boolean create() throws IOException;

    public void truncate() throws IOException;

    public boolean move(SshFile var1);

    public List<SshFile> listSshFiles();

    public OutputStream createOutputStream(long var1) throws IOException;

    public InputStream createInputStream(long var1) throws IOException;

    public void handleClose() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permission {
        UserRead,
        UserWrite,
        UserExecute,
        GroupRead,
        GroupWrite,
        GroupExecute,
        OthersRead,
        OthersWrite,
        OthersExecute;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        Size,
        Uid,
        Owner,
        Gid,
        Group,
        IsDirectory,
        IsRegularFile,
        IsSymbolicLink,
        Permissions,
        CreationTime,
        LastModifiedTime,
        LastAccessTime;

    }
}

