/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.List;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.model.TrainUtil;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    protected BeamSearch<String> beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator, ChunkerContextGenerator contextGenerator) {
        this.model = model.getChunkerModel();
        this.beam = new BeamSearch<String>(beamSize, contextGenerator, this.model, sequenceValidator, 0);
    }

    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator) {
        this(model, beamSize, sequenceValidator, new DefaultChunkerContextGenerator());
    }

    public ChunkerME(ChunkerModel model, int beamSize) {
        this.model = model.getChunkerModel();
        ChunkerContextGenerator contextGenerator = model.getFactory().getContextGenerator();
        SequenceValidator<String> sequenceValidator = model.getFactory().getSequenceValidator();
        this.beam = new BeamSearch<String>(beamSize, contextGenerator, this.model, sequenceValidator, 0);
    }

    public ChunkerME(ChunkerModel model) {
        this(model, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod) {
        this(mod, new DefaultChunkerContextGenerator(), 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg) {
        this(mod, cg, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg, int beamSize) {
        this.beam = new BeamSearch<String>(beamSize, cg, mod);
        this.model = mod;
    }

    @Override
    @Deprecated
    public List<String> chunk(List<String> toks, List<String> tags) {
        this.bestSequence = this.beam.bestSequence((String[])toks.toArray(new String[toks.size()]), new Object[]{tags.toArray(new String[tags.size()])});
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] chunk(String[] toks, String[] tags) {
        this.bestSequence = this.beam.bestSequence((String[])toks, new Object[]{tags});
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    @Override
    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        String[] preds = this.chunk(toks, tags);
        return ChunkSample.phrasesAsSpanList(toks, tags, preds);
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> sentence, List<String> tags) {
        return this.topKSequences(sentence.toArray(new String[sentence.size()]), tags.toArray(new String[tags.size()]));
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.beam.bestSequences(10, (String[])sentence, new Object[]{tags});
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.beam.bestSequences(10, (String[])sentence, new Object[]{tags}, minSequenceScore);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, TrainingParameters mlParams, ChunkerFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        ChunkerEventStream es = new ChunkerEventStream(in, factory.getContextGenerator());
        AbstractModel maxentModel = TrainUtil.train(es, mlParams.getSettings(), manifestInfoEntries);
        return new ChunkerModel(lang, maxentModel, manifestInfoEntries, factory);
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, ChunkerContextGenerator contextGenerator, TrainingParameters mlParams) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        ChunkerEventStream es = new ChunkerEventStream(in, contextGenerator);
        AbstractModel maxentModel = TrainUtil.train(es, mlParams.getSettings(), manifestInfoEntries);
        return new ChunkerModel(lang, maxentModel, manifestInfoEntries);
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, int cutoff, int iterations, ChunkerContextGenerator contextGenerator) throws IOException {
        return ChunkerME.train(lang, in, contextGenerator, ModelUtil.createTrainingParameters(iterations, cutoff));
    }

    @Deprecated
    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, int cutoff, int iterations) throws IOException, ObjectStreamException {
        return ChunkerME.train(lang, in, cutoff, iterations, new DefaultChunkerContextGenerator());
    }
}

