/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.coref;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.LinkerMode;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.lang.english.TreebankLinker;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public class CoreferencerTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "learnable noun phrase coreferencer";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            TreebankLinker treebankLinker;
            try {
                treebankLinker = new TreebankLinker(args[0], LinkerMode.TEST);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load all coreferencer models!", e);
            }
            PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "parses");
            perfMon.start();
            try {
                String line;
                int sentenceNumber = 0;
                ArrayList<Mention> document = new ArrayList<Mention>();
                ArrayList<Parse> parses = new ArrayList<Parse>();
                while ((line = (String)lineStream.read()) != null) {
                    if (line.equals("")) {
                        DiscourseEntity[] entities = treebankLinker.getEntities(document.toArray(new Mention[document.size()]));
                        new CorefParse(parses, entities).show();
                        sentenceNumber = 0;
                        document.clear();
                        parses.clear();
                    } else {
                        Parse p = Parse.parseParse(line);
                        parses.add(p);
                        Mention[] extents = treebankLinker.getMentionFinder().getMentions(new DefaultParse(p, sentenceNumber));
                        int en = extents.length;
                        for (int ei = 0; ei < en; ++ei) {
                            if (extents[ei].getParse() != null) continue;
                            Parse snp = new Parse(p.getText(), extents[ei].getSpan(), "NML", 1.0, 0);
                            p.insert(snp);
                            extents[ei].setParse(new DefaultParse(snp, sentenceNumber));
                        }
                        document.addAll(Arrays.asList(extents));
                        ++sentenceNumber;
                    }
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model_directory < parses";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CorefParse {
        private Map<Parse, Integer> parseMap;
        private List<Parse> parses;

        public CorefParse(List<Parse> parses, DiscourseEntity[] entities) {
            this.parses = parses;
            this.parseMap = new HashMap<Parse, Integer>();
            int en = entities.length;
            for (int ei = 0; ei < en; ++ei) {
                if (entities[ei].getNumMentions() <= 1) continue;
                Iterator<MentionContext> mi = entities[ei].getMentions();
                while (mi.hasNext()) {
                    MentionContext mc = mi.next();
                    Parse mentionParse = ((DefaultParse)mc.getParse()).getParse();
                    this.parseMap.put(mentionParse, ei + 1);
                }
            }
        }

        public void show() {
            int pn = this.parses.size();
            for (int pi = 0; pi < pn; ++pi) {
                Parse p = this.parses.get(pi);
                this.show(p);
                System.out.println();
            }
        }

        private void show(Parse p) {
            int start = p.getSpan().getStart();
            if (!p.getType().equals("TK")) {
                System.out.print("(");
                System.out.print(p.getType());
                if (this.parseMap.containsKey(p)) {
                    System.out.print("#" + this.parseMap.get(p));
                }
                System.out.print(" ");
            }
            for (Parse c : p.getChildren()) {
                Span s = c.getSpan();
                if (start < s.getStart()) {
                    System.out.print(p.getText().substring(start, s.getStart()));
                }
                this.show(c);
                start = s.getEnd();
            }
            System.out.print(p.getText().substring(start, p.getSpan().getEnd()));
            if (!p.getType().equals("TK")) {
                System.out.print(")");
            }
        }
    }
}

