/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Collection;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.featuregen.StringPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagOfWordsFeatureGenerator
implements FeatureGenerator {
    private boolean useOnlyAllLetterTokens = false;

    public BagOfWordsFeatureGenerator() {
    }

    BagOfWordsFeatureGenerator(boolean useOnlyAllLetterTokens) {
        this.useOnlyAllLetterTokens = useOnlyAllLetterTokens;
    }

    @Override
    public Collection<String> extractFeatures(String[] text) {
        ArrayList<String> bagOfWords = new ArrayList<String>(text.length);
        for (String word : text) {
            if (this.useOnlyAllLetterTokens) {
                StringPattern pattern = StringPattern.recognize(word);
                if (!pattern.isAllLetter()) continue;
                bagOfWords.add("bow=" + word);
                continue;
            }
            bagOfWords.add("bow=" + word);
        }
        return bagOfWords;
    }
}

