/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.coref.CorefSample;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.muc.FullParseCorefEnhancerStream;
import opennlp.tools.formats.muc.MucCorefSampleStream;
import opennlp.tools.formats.muc.MucMentionInserterStream;
import opennlp.tools.formats.muc.NameFinderCorefEnhancerStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Muc6FullParseCorefSampleStreamFactory
extends AbstractSampleStreamFactory<CorefSample> {
    protected Muc6FullParseCorefSampleStreamFactory() {
        super(Parameters.class);
    }

    @Override
    public ObjectStream<CorefSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        ParserModel parserModel = (ParserModel)new ParserModelLoader().load(params.getParserModel());
        Parser parser = ParserFactory.create(parserModel);
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(params.getTokenizerModel());
        TokenizerME tokenizer = new TokenizerME(tokenizerModel);
        FileToStringSampleStream mucDocStream = new FileToStringSampleStream(new DirectorySampleStream(params.getData(), new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sgm");
            }
        }, false), Charset.forName("UTF-8"));
        MucCorefSampleStream rawSamples = new MucCorefSampleStream(tokenizer, mucDocStream);
        FullParseCorefEnhancerStream parsedSamples = new FullParseCorefEnhancerStream(parser, rawSamples);
        HashMap<String, File> modelFileTagMap = new HashMap<String, File>();
        modelFileTagMap.put("person", params.getPersonModel());
        modelFileTagMap.put("organization", params.getOrganizationModel());
        ArrayList<NameFinderME> nameFinders = new ArrayList<NameFinderME>();
        ArrayList tags = new ArrayList();
        for (Map.Entry entry : modelFileTagMap.entrySet()) {
            nameFinders.add(new NameFinderME((TokenNameFinderModel)new TokenNameFinderModelLoader().load((File)entry.getValue())));
            tags.add(entry.getKey());
        }
        return new MucMentionInserterStream(new NameFinderCorefEnhancerStream(nameFinders.toArray(new TokenNameFinder[nameFinders.size()]), tags.toArray(new String[tags.size()]), parsedSamples));
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(CorefSample.class, "muc6full", new Muc6FullParseCorefSampleStreamFactory());
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getParserModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getPersonModel();

        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getOrganizationModel();
    }
}

