/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineContext;
import org.guvnor.ala.util.VariableInterpolation;

public class PipelineExecutor {
    private final Map<Class, ConfigExecutor> configExecutors = new HashMap<Class, ConfigExecutor>();

    public PipelineExecutor() {
    }

    public void init(Collection<ConfigExecutor> configExecutors) {
        for (ConfigExecutor configExecutor : configExecutors) {
            this.configExecutors.put(configExecutor.executeFor(), configExecutor);
        }
    }

    public PipelineExecutor(Collection<ConfigExecutor> configExecutors) {
        this.init(configExecutors);
    }

    public <T> void execute(Input input, Pipeline pipeline, Consumer<T> callback, PipelineEventListener ... eventListeners) {
        PipelineContext context = new PipelineContext(pipeline);
        context.start(input);
        context.pushCallback(callback);
        this.propagateEvent(new BeforePipelineExecutionEvent(pipeline), eventListeners);
        this.continuePipeline(context, eventListeners);
        this.propagateEvent(new AfterPipelineExecutionEvent(pipeline), eventListeners);
    }

    private void continuePipeline(PipelineContext context, PipelineEventListener ... eventListeners) {
        while (!context.isFinished()) {
            Stage<Object, ?> stage = PipelineExecutor.getCurrentStage(context);
            Object newInput = PipelineExecutor.pollOutput(context);
            try {
                this.propagateEvent(new BeforeStageExecutionEvent(context.getPipeline(), stage), eventListeners);
                stage.execute(newInput, output -> {
                    ConfigExecutor executor = this.resolve(output.getClass());
                    if (output instanceof ContextAware) {
                        ((ContextAware)output).setContext(Collections.unmodifiableMap(context.getValues()));
                    }
                    Object newOutput = VariableInterpolation.interpolate(context.getValues(), output);
                    if (executor == null) {
                        throw new RuntimeException("Fail to resolve ConfigExecutor for: " + output.getClass());
                    }
                    context.getValues().put(executor.inputId(), newOutput);
                    if (executor instanceof BiFunctionConfigExecutor) {
                        Optional result = (Optional)((BiFunctionConfigExecutor)executor).apply(newInput, newOutput);
                        context.pushOutput(executor.outputId(), result.get());
                    } else if (executor instanceof FunctionConfigExecutor) {
                        Optional result = (Optional)((FunctionConfigExecutor)executor).apply(newOutput);
                        context.pushOutput(executor.outputId(), result.get());
                    }
                    this.propagateEvent(new AfterStageExecutionEvent(context.getPipeline(), stage), eventListeners);
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
                RuntimeException exception = new RuntimeException("An error occurred while executing the " + (stage == null ? "null" : stage.getName()) + " stage.", t);
                this.propagateEvent(new OnErrorStageExecutionEvent(context.getPipeline(), stage, exception), eventListeners);
                this.propagateEvent(new OnErrorPipelineExecutionEvent(context.getPipeline(), stage, exception), eventListeners);
                throw exception;
            }
        }
        Object output2 = PipelineExecutor.pollOutput(context);
        while (context.hasCallbacks()) {
            context.applyCallbackAndPop(output2);
        }
    }

    private ConfigExecutor resolve(Class<?> clazz) {
        ConfigExecutor result = this.configExecutors.get(clazz);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Class, ConfigExecutor> entry : this.configExecutors.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Object pollOutput(PipelineContext context) {
        return context.pollOutput().orElseThrow(() -> new IllegalStateException("The " + PipelineContext.class.getSimpleName() + " was polled with no previous output."));
    }

    private static Stage<Object, ?> getCurrentStage(PipelineContext context) {
        return context.getCurrentStage().orElseThrow(() -> new IllegalStateException("There was not current stage even though the process has not finished."));
    }

    private void propagateEvent(BeforePipelineExecutionEvent beforePipelineExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.beforePipelineExecution(beforePipelineExecutionEvent);
        }
    }

    private void propagateEvent(BeforeStageExecutionEvent beforeStageExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.beforeStageExecution(beforeStageExecutionEvent);
        }
    }

    private void propagateEvent(AfterStageExecutionEvent afterStageExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.afterStageExecution(afterStageExecutionEvent);
        }
    }

    private void propagateEvent(OnErrorStageExecutionEvent onErrorStageExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.onStageError(onErrorStageExecutionEvent);
        }
    }

    private void propagateEvent(OnErrorPipelineExecutionEvent onErrorPipelineExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.onPipelineError(onErrorPipelineExecutionEvent);
        }
    }

    private void propagateEvent(AfterPipelineExecutionEvent afterPipelineExecutionEvent, PipelineEventListener ... eventListeners) {
        for (PipelineEventListener eventListener : eventListeners) {
            eventListener.afterPipelineExecution(afterPipelineExecutionEvent);
        }
    }
}

