/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base.dotfiles;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AttrHolder;
import org.uberfire.java.nio.base.Properties;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public final class DotFileUtils {
    private DotFileUtils() {
    }

    public static boolean buildDotFile(Path path, OutputStream out, FileAttribute<?> ... attrs) {
        boolean hasContent = false;
        if (attrs != null && attrs.length > 0) {
            Properties properties = new Properties();
            for (FileAttribute<?> attr : attrs) {
                if (!(attr.value() instanceof Serializable)) continue;
                hasContent = true;
                properties.put(attr.name(), attr.value());
            }
            if (hasContent) {
                try {
                    properties.store(out);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (path instanceof AttrHolder) {
                ((AttrHolder)((Object)path)).getAttrStorage().loadContent(properties);
            }
        } else {
            path.getFileSystem().provider().deleteIfExists(DotFileUtils.dot(path), new DeleteOption[0]);
        }
        if (!hasContent) {
            try {
                out.close();
            }
            catch (java.io.IOException iOException) {
                // empty catch block
            }
        }
        return hasContent;
    }

    public static Path dot(Path path) {
        if (path.getFileName() == null) {
            return path.resolve(".root");
        }
        return path.resolveSibling("." + path.getFileName());
    }

    public static Path undot(Path path) {
        if (!path.getFileName().toString().startsWith(".")) {
            return path;
        }
        return path.resolveSibling(path.getFileName().toString().substring(1));
    }

    public static FileAttribute<?>[] consolidate(Map<String, Object> props, FileAttribute<?> ... attrs) {
        if (props == null || props.size() == 0) {
            return attrs;
        }
        HashMap<String, Object> temp = new HashMap<String, Object>(props);
        for (FileAttribute<?> fileAttribute : attrs) {
            temp.put(fileAttribute.name(), fileAttribute.value());
        }
        FileAttribute[] result = new FileAttribute[temp.size()];
        int i = -1;
        for (final Map.Entry entry : temp.entrySet()) {
            result[++i] = new FileAttribute<Object>(){

                @Override
                public String name() {
                    return (String)entry.getKey();
                }

                @Override
                public Object value() {
                    return entry.getValue();
                }
            };
        }
        return result;
    }
}

