/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.metadata;

import java.net.URI;
import java.util.UUID;
import org.drools.core.factmodel.traits.InstantiatorFactory;
import org.drools.core.metadata.AbstractWMTask;
import org.drools.core.metadata.MetaCallableTask;
import org.drools.core.metadata.Metadatable;
import org.drools.core.metadata.Modify;
import org.drools.core.metadata.ModifyLiteral;
import org.drools.core.metadata.NewInstance;
import org.drools.core.metadata.With;

public abstract class NewInstanceLiteral<T extends Metadatable>
extends AbstractWMTask<T>
implements NewInstance<T> {
    protected URI uri;
    protected T result;
    protected ModifyLiteral setter;
    protected InstantiatorFactory instantiatorFactory;
    protected With[] with;

    public NewInstanceLiteral(With ... args) {
        this.with = args;
    }

    public NewInstanceLiteral(Object identifier, With ... args) {
        this.uri = URI.create(identifier.toString());
        this.with = args;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public MetaCallableTask.KIND kind() {
        return MetaCallableTask.KIND.ASSERT;
    }

    @Override
    public Object getTargetId() {
        return this.uri;
    }

    @Override
    public Object callUntyped() {
        return this.construct();
    }

    @Override
    public Modify getInitArgs() {
        return this.setter;
    }

    @Override
    public T call() {
        this.result = (Metadatable)this.construct();
        if (this.setter != null) {
            this.setter.setTarget(this.result);
            this.setter.call();
        }
        return this.result;
    }

    protected abstract Object construct();

    protected void constructId(Class<?> klass) {
        if (this.uri == null) {
            this.uri = URI.create(this.getInstantiatorFactory() != null ? this.getInstantiatorFactory().createId(klass).toString() : UUID.randomUUID().toString());
        }
    }

    @Override
    public InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    @Override
    public NewInstance<T> setInstantiatorFactory(InstantiatorFactory instantiatorFactory) {
        this.instantiatorFactory = instantiatorFactory;
        return this;
    }

    @Override
    public URI getUri() {
        return URI.create(this.uri.toString() + "?create");
    }

    @Override
    public Object getId() {
        return this.uri;
    }

    @Override
    public ModifyLiteral<T> getSetters() {
        return this.setter;
    }

    @Override
    public T getTarget() {
        return this.result;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

