/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.LowerCaseOnlyAnalyzer;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

public final class ImpactAnalysisAnalyzerWrapper
extends DelegatingAnalyzerWrapper {
    private final LowerCaseOnlyAnalyzer lowerCaseOnlyAnalyzer = new LowerCaseOnlyAnalyzer();
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> fieldAnalyzers;
    private static final String RESOURCE_REF_FIELD_NAME_BEGIN = "ref:";
    private static final String SHARED_PART_REF_FIELD_NAME_BEGIN = "shared:";
    private static final String PACKAGE_NAME_FIELD_NAME = "packageName";
    private static final String PROJECT_NAME_FIELD_NAME = "projectName";
    private static final String PROJECT_ROOT_PATH_FIELD_NAME = "projectRoot";
    private static final String[] PART_FIELD_NAME_BEGINS;
    private static final String[] RESOURCE_FIELD_NAME_BEGINS;

    public ImpactAnalysisAnalyzerWrapper() {
        this((Analyzer)new StandardAnalyzer(CharArraySet.EMPTY_SET), Collections.EMPTY_MAP);
    }

    public ImpactAnalysisAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = fieldAnalyzers != null ? fieldAnalyzers : Collections.emptyMap();
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.fieldAnalyzers.get(fieldName);
        if (analyzer == null) {
            if (fieldName.startsWith(RESOURCE_REF_FIELD_NAME_BEGIN)) {
                analyzer = this.lowerCaseOnlyAnalyzer;
            } else if (fieldName.startsWith(SHARED_PART_REF_FIELD_NAME_BEGIN)) {
                analyzer = this.lowerCaseOnlyAnalyzer;
            } else if (fieldName.startsWith(PACKAGE_NAME_FIELD_NAME)) {
                analyzer = this.lowerCaseOnlyAnalyzer;
            } else if (fieldName.startsWith(PROJECT_NAME_FIELD_NAME)) {
                analyzer = this.lowerCaseOnlyAnalyzer;
            } else if (fieldName.startsWith(PROJECT_ROOT_PATH_FIELD_NAME)) {
                analyzer = this.lowerCaseOnlyAnalyzer;
            } else {
                boolean found = false;
                for (String typeFieldNameStart : RESOURCE_FIELD_NAME_BEGINS) {
                    if (!fieldName.startsWith(typeFieldNameStart)) continue;
                    analyzer = this.lowerCaseOnlyAnalyzer;
                    found = true;
                    break;
                }
                if (!found) {
                    for (String typeFieldNameStart : PART_FIELD_NAME_BEGINS) {
                        if (!fieldName.startsWith(typeFieldNameStart)) continue;
                        analyzer = this.lowerCaseOnlyAnalyzer;
                        break;
                    }
                }
            }
        }
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "ImpactAnalysisAnalyzerWrapper(" + this.fieldAnalyzers + ", default=" + this.defaultAnalyzer + ")";
    }

    static {
        int i;
        PartType[] partTypes = PartType.values();
        PART_FIELD_NAME_BEGINS = new String[partTypes.length];
        for (i = 0; i < partTypes.length; ++i) {
            ImpactAnalysisAnalyzerWrapper.PART_FIELD_NAME_BEGINS[i] = partTypes[i].toString() + ":";
        }
        ResourceType[] resTypes = ResourceType.values();
        RESOURCE_FIELD_NAME_BEGINS = new String[resTypes.length];
        for (i = 0; i < resTypes.length; ++i) {
            ImpactAnalysisAnalyzerWrapper.RESOURCE_FIELD_NAME_BEGINS[i] = resTypes[i].toString() + ":";
        }
    }
}

