/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQueries;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllChangeImpactQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RefactoringQueryServiceImpl
implements RefactoringQueryService {
    private LuceneConfig config;
    private NamedQueries namedQueries;
    private PageResponse<RefactoringPageRow> emptyResponse;

    public RefactoringQueryServiceImpl() {
    }

    @Inject
    public RefactoringQueryServiceImpl(@Named(value="luceneConfig") LuceneConfig config, NamedQueries namedQueries) {
        this.config = (LuceneConfig)PortablePreconditions.checkNotNull((String)"config", (Object)config);
        this.namedQueries = (NamedQueries)PortablePreconditions.checkNotNull((String)"namedQueries", (Object)namedQueries);
    }

    @PostConstruct
    public void init() {
        this.emptyResponse = new PageResponse();
        this.emptyResponse.setPageRowList(Collections.emptyList());
        this.emptyResponse.setStartRowIndex(0);
        this.emptyResponse.setTotalRowSize(0);
        this.emptyResponse.setLastPage(true);
        this.emptyResponse.setTotalRowSizeExact(true);
    }

    public Set<String> getQueries() {
        return this.namedQueries.getQueries();
    }

    public PageResponse<RefactoringPageRow> query(RefactoringPageRequest request) {
        PortablePreconditions.checkNotNull((String)"request", (Object)request);
        String queryName = (String)PortablePreconditions.checkNotNull((String)"queryName", (Object)request.getQueryName());
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        namedQuery.validateTerms(request.getQueryTerms());
        Query query = namedQuery.toQuery(request.getQueryTerms());
        int pageSize = request.getPageSize();
        int startIndex = request.getStartRowIndex();
        List<KObject> kObjects = this.search(query, hits -> (startIndex + 1) * (pageSize > 0 ? pageSize : 1), collector -> collector.topDocs((int)startIndex).scoreDocs, numHits -> numHits > pageSize ? pageSize : numHits, new ClusterSegment[0]);
        if (!kObjects.isEmpty()) {
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(pageSize, startIndex, kObjects);
        }
        return this.emptyResponse;
    }

    public List<RefactoringPageRow> query(String queryName, Set<ValueIndexTerm> queryTerms) {
        PortablePreconditions.checkNotNull((String)"queryName", (Object)queryName);
        PortablePreconditions.checkNotNull((String)"queryTerms", queryTerms);
        NamedQuery namedQuery = this.namedQueries.findNamedQuery(queryName);
        namedQuery.validateTerms(queryTerms);
        Query query = namedQuery.toQuery(queryTerms);
        List<KObject> kObjects = this.search(query, hits -> hits, collector -> collector.topDocs().scoreDocs, numHits -> numHits, new ClusterSegment[0]);
        if (!kObjects.isEmpty()) {
            ResponseBuilder responseBuilder = namedQuery.getResponseBuilder();
            return responseBuilder.buildResponse(kObjects);
        }
        return Collections.emptyList();
    }

    private List<KObject> search(Query query, IntFunction<Integer> totalHitsSupplier, Function<TopScoreDocCollector, ScoreDoc[]> getDocsHitFunction, IntFunction<Integer> numDocsInResponseFunction, ClusterSegment ... clusterSegments) {
        LuceneIndexManager indexManager = (LuceneIndexManager)this.config.getIndexManager();
        IndexSearcher index = indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>();
        try {
            TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
            index.search(query, (Collector)totalHitCountCollector);
            int numHits = totalHitCountCollector.getTotalHits();
            if (numHits > 0) {
                TopScoreDocCollector topScoreDocCollector = TopScoreDocCollector.create((int)totalHitsSupplier.apply(numHits));
                index.search(query, (Collector)topScoreDocCollector);
                ScoreDoc[] docsHit = getDocsHitFunction.apply(topScoreDocCollector);
                int numDocs = numDocsInResponseFunction.apply(docsHit.length);
                for (int i = 0; i < numDocs; ++i) {
                    result.add(KObjectUtil.toKObject((Document)index.doc(docsHit[i].doc)));
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            indexManager.release(index);
        }
        return result;
    }

    public PageResponse<RefactoringPageRow> queryToPageResponse(QueryOperationRequest queryOpRequest) {
        RefactoringPageRequest request = this.convertToRefactoringPageRequest(queryOpRequest);
        PageResponse<RefactoringPageRow> response = this.query(request);
        return response;
    }

    public List<RefactoringPageRow> queryToList(QueryOperationRequest queryOpRequest) {
        RefactoringPageRequest request = this.convertToRefactoringPageRequest(queryOpRequest);
        List<RefactoringPageRow> response = this.query(request.getQueryName(), request.getQueryTerms());
        return response;
    }

    private RefactoringPageRequest convertToRefactoringPageRequest(QueryOperationRequest refOpRequest) {
        String branchName;
        String projectRootPathURI;
        RefactoringPageRequest request = new RefactoringPageRequest(FindAllChangeImpactQuery.NAME, new HashSet(), refOpRequest.getStartRowIndex(), refOpRequest.getPageSize());
        request.getQueryTerms().addAll(refOpRequest.getQueryTerms());
        String projectName = refOpRequest.getProjectName();
        if (projectName != null && projectName != QueryOperationRequest.ALL) {
            ValueProjectNameIndexTerm valueIndexTerm = new ValueProjectNameIndexTerm(projectName);
            HashSet<ValueProjectNameIndexTerm> queryTerms = new HashSet<ValueProjectNameIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        if ((projectRootPathURI = refOpRequest.getProjectRootPathURI()) != null && projectRootPathURI != QueryOperationRequest.ALL) {
            ValueProjectRootPathIndexTerm valueIndexTerm = new ValueProjectRootPathIndexTerm(projectRootPathURI);
            HashSet<ValueProjectRootPathIndexTerm> queryTerms = new HashSet<ValueProjectRootPathIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        if ((branchName = refOpRequest.getBranchName()) != null && branchName != QueryOperationRequest.ALL) {
            ValueBranchNameIndexTerm valueIndexTerm = new ValueBranchNameIndexTerm(branchName);
            HashSet<ValueBranchNameIndexTerm> queryTerms = new HashSet<ValueBranchNameIndexTerm>(1);
            queryTerms.add(valueIndexTerm);
            request.getQueryTerms().addAll(queryTerms);
        }
        return request;
    }
}

