/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.response;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPathPageRow;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class DefaultResponseBuilder
implements ResponseBuilder {
    private IOService ioService;

    public DefaultResponseBuilder() {
    }

    @Inject
    public DefaultResponseBuilder(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
    }

    @Override
    public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
        int hits = kObjects.size();
        PageResponse response = new PageResponse();
        List<RefactoringPageRow> result = this.buildResponse(kObjects);
        response.setTotalRowSize(hits);
        response.setPageRowList(result);
        response.setTotalRowSizeExact(true);
        response.setStartRowIndex(startRow);
        response.setLastPage(pageSize * startRow + 2 >= hits);
        return response;
    }

    @Override
    public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
        ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
        for (KObject kObject : kObjects) {
            org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
            RefactoringPathPageRow row = new RefactoringPathPageRow();
            row.setValue((Object)path);
            result.add((RefactoringPageRow)row);
        }
        return result;
    }
}

