/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.events.CredentialsInitializedEvent;
import org.jboss.seam.security.events.CredentialsUpdatedEvent;
import org.jboss.seam.security.events.LoginFailedEvent;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.impl.api.PasswordCredential;

@Named(value="credentials")
@SessionScoped
public class CredentialsImpl
implements Credentials,
Serializable {
    private static final long serialVersionUID = -2271248957776488426L;
    @Inject
    BeanManager manager;
    private String username;
    private Credential credential;
    private boolean invalid;
    private boolean initialized;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getUsername() {
        if (!this.isInitialized()) {
            this.setInitialized(true);
            this.manager.fireEvent((Object)new CredentialsInitializedEvent((Credentials)this), new Annotation[0]);
        }
        return this.username;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public void setUsername(String username) {
        if (!(this.username == username || this.username != null && this.username.equals(username))) {
            this.username = username;
            this.invalid = false;
            this.manager.fireEvent((Object)new CredentialsUpdatedEvent(), new Annotation[0]);
        }
    }

    public String getPassword() {
        return this.credential != null && this.credential instanceof PasswordCredential ? ((PasswordCredential)this.credential).getValue() : null;
    }

    public void setPassword(String password) {
        if (this.credential == null) {
            this.credential = new PasswordCredential(password);
        } else if (this.credential != null && this.credential instanceof PasswordCredential && ((PasswordCredential)this.credential).getValue() != password && ((PasswordCredential)this.credential).getValue() == null || !((PasswordCredential)this.credential).getValue().equals(password)) {
            this.credential = new PasswordCredential(password);
            this.invalid = false;
            this.manager.fireEvent((Object)new CredentialsUpdatedEvent(), new Annotation[0]);
        }
    }

    public boolean isSet() {
        return this.getUsername() != null && this.credential != null && ((PasswordCredential)this.credential).getValue() != null;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public void clear() {
        this.username = null;
        this.credential = null;
        this.initialized = false;
    }

    public void loginFailed(@Observes LoginFailedEvent event) {
        this.invalidate();
    }

    public String toString() {
        return "Credentials[" + this.username + "]";
    }
}

