/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui.impl;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.dom.client.Element;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.impl.RichTextAreaImpl;

public abstract class RichTextAreaImplStandard
extends RichTextAreaImpl
implements RichTextArea.Formatter {
    private static final String INACTIVE_MESSAGE = "RichTextArea formatters cannot be used until the RichTextArea is attached and focused.";
    private Element beforeInitPlaceholder = DOM.createDiv();
    protected boolean initializing;
    private boolean isPendingFocus;
    private boolean isReady;

    @Override
    public native Element createElement();

    @Override
    public void createLink(String url) {
        this.execCommand("CreateLink", url);
    }

    @Override
    public String getBackColor() {
        return this.queryCommandValue("BackColor");
    }

    @Override
    public String getForeColor() {
        return this.queryCommandValue("ForeColor");
    }

    @Override
    public final String getHTML() {
        return this.beforeInitPlaceholder == null ? this.getHTMLImpl() : this.beforeInitPlaceholder.getInnerHTML();
    }

    @Override
    public final String getText() {
        return this.beforeInitPlaceholder == null ? this.getTextImpl() : this.beforeInitPlaceholder.getInnerText();
    }

    @Override
    public native void initElement();

    @Override
    public void insertHorizontalRule() {
        this.execCommand("InsertHorizontalRule", null);
    }

    @Override
    public void insertHTML(@IsSafeHtml String html) {
        this.execCommand("InsertHTML", html);
    }

    @Override
    public void insertImage(String url) {
        this.execCommand("InsertImage", url);
    }

    @Override
    public void insertOrderedList() {
        this.execCommand("InsertOrderedList", null);
    }

    @Override
    public void insertUnorderedList() {
        this.execCommand("InsertUnorderedList", null);
    }

    @Override
    public boolean isBold() {
        return this.queryCommandState("Bold");
    }

    @Override
    public boolean isEnabled() {
        return this.beforeInitPlaceholder == null ? this.isEnabledImpl() : !this.beforeInitPlaceholder.getPropertyBoolean("disabled");
    }

    @Override
    public boolean isItalic() {
        return this.queryCommandState("Italic");
    }

    @Override
    public boolean isStrikethrough() {
        return this.queryCommandState("Strikethrough");
    }

    @Override
    public boolean isSubscript() {
        return this.queryCommandState("Subscript");
    }

    @Override
    public boolean isSuperscript() {
        return this.queryCommandState("Superscript");
    }

    @Override
    public boolean isUnderlined() {
        return this.queryCommandState("Underline");
    }

    @Override
    public void leftIndent() {
        this.execCommand("Outdent", null);
    }

    @Override
    public void redo() {
        this.execCommand("Redo", "false");
    }

    @Override
    public void removeFormat() {
        this.execCommand("RemoveFormat", null);
    }

    @Override
    public void removeLink() {
        this.execCommand("Unlink", "false");
    }

    @Override
    public void rightIndent() {
        this.execCommand("Indent", null);
    }

    @Override
    public void selectAll() {
        this.execCommand("SelectAll", null);
    }

    @Override
    public void setBackColor(String color) {
        this.execCommand("BackColor", color);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.beforeInitPlaceholder == null) {
            this.setEnabledImpl(enabled);
        } else {
            this.beforeInitPlaceholder.setPropertyBoolean("disabled", !enabled);
        }
    }

    @Override
    public void setFocus(boolean focused) {
        if (this.initializing) {
            this.isPendingFocus = focused;
        } else {
            this.setFocusImpl(focused);
        }
    }

    @Override
    public void setFontName(String name) {
        this.execCommand("FontName", name);
    }

    @Override
    public void setFontSize(RichTextArea.FontSize fontSize) {
        this.execCommand("FontSize", Integer.toString(fontSize.getNumber()));
    }

    @Override
    public void setForeColor(String color) {
        this.execCommand("ForeColor", color);
    }

    @Override
    public final void setHTML(@IsSafeHtml String html) {
        if (this.beforeInitPlaceholder == null) {
            this.setHTMLImpl(html);
        } else {
            this.beforeInitPlaceholder.setInnerHTML(html);
        }
    }

    @Override
    public void setJustification(RichTextArea.Justification justification) {
        if (justification == RichTextArea.Justification.CENTER) {
            this.execCommand("JustifyCenter", null);
        } else if (justification == RichTextArea.Justification.FULL) {
            this.execCommand("JustifyFull", null);
        } else if (justification == RichTextArea.Justification.LEFT) {
            this.execCommand("JustifyLeft", null);
        } else if (justification == RichTextArea.Justification.RIGHT) {
            this.execCommand("JustifyRight", null);
        }
    }

    @Override
    public final void setText(String text) {
        if (this.beforeInitPlaceholder == null) {
            this.setTextImpl(text);
        } else {
            this.beforeInitPlaceholder.setInnerText(text);
        }
    }

    @Override
    public void toggleBold() {
        this.execCommand("Bold", "false");
    }

    @Override
    public void toggleItalic() {
        this.execCommand("Italic", "false");
    }

    @Override
    public void toggleStrikethrough() {
        this.execCommand("Strikethrough", "false");
    }

    @Override
    public void toggleSubscript() {
        this.execCommand("Subscript", "false");
    }

    @Override
    public void toggleSuperscript() {
        this.execCommand("Superscript", "false");
    }

    @Override
    public void toggleUnderline() {
        this.execCommand("Underline", "False");
    }

    @Override
    public void undo() {
        this.execCommand("Undo", "false");
    }

    @Override
    @SuppressIsSafeHtmlCastCheck
    public void uninitElement() {
        this.isReady = false;
        if (this.initializing) {
            this.initializing = false;
            return;
        }
        this.unhookEvents();
        String html = this.getHTML();
        boolean enabled = this.isEnabled();
        this.beforeInitPlaceholder = DOM.createDiv();
        this.beforeInitPlaceholder.setInnerHTML(html);
        this.setEnabled(enabled);
    }

    protected native String getHTMLImpl();

    protected native String getTextImpl();

    @Override
    protected native void hookEvents();

    protected native boolean isEnabledImpl();

    @Override
    @SuppressIsSafeHtmlCastCheck
    protected void onElementInitialized() {
        if (!this.initializing) {
            return;
        }
        this.initializing = false;
        this.isReady = true;
        if (this.beforeInitPlaceholder != null) {
            this.setHTMLImpl(this.beforeInitPlaceholder.getInnerHTML());
            this.setEnabledImpl(this.isEnabled());
            this.beforeInitPlaceholder = null;
        }
        super.onElementInitialized();
        if (this.isPendingFocus) {
            this.isPendingFocus = false;
            this.setFocus(true);
        }
    }

    protected void onElementInitializing() {
        this.initializing = true;
        this.isPendingFocus = false;
    }

    protected native void setEnabledImpl(boolean var1);

    protected native void setFocusImpl(boolean var1);

    protected native void setHTMLImpl(@IsSafeHtml String var1);

    protected native void setTextImpl(String var1);

    protected native void unhookEvents();

    void execCommand(String cmd, String param) {
        assert (this.isReady) : "RichTextArea formatters cannot be used until the RichTextArea is attached and focused.";
        if (this.isReady) {
            this.setFocus(true);
            try {
                this.execCommandAssumingFocus(cmd, param);
            }
            catch (JavaScriptException javaScriptException) {
                // empty catch block
            }
        }
    }

    native void execCommandAssumingFocus(String var1, String var2);

    boolean queryCommandState(String cmd) {
        if (this.isReady) {
            this.setFocus(true);
            try {
                return this.queryCommandStateAssumingFocus(cmd);
            }
            catch (JavaScriptException e) {
                return false;
            }
        }
        return false;
    }

    native boolean queryCommandStateAssumingFocus(String var1);

    String queryCommandValue(String cmd) {
        if (this.isReady) {
            this.setFocus(true);
            try {
                return this.queryCommandValueAssumingFocus(cmd);
            }
            catch (JavaScriptException e) {
                return "";
            }
        }
        return "";
    }

    native String queryCommandValueAssumingFocus(String var1);
}

