/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

final class CopyTransform
extends AbstractLinearTransform
implements Serializable {
    private static final long serialVersionUID = 5457032501070947956L;
    private final int srcDim;
    private final int[] indices;
    private transient MathTransform inverse;

    CopyTransform(int n, int[] nArray) {
        this.srcDim = n;
        this.indices = nArray;
    }

    static CopyTransform create(Matrix matrix) {
        int n = matrix.getNumCol() - 1;
        int n2 = matrix.getNumRow() - 1;
        for (int i = 0; i <= n; ++i) {
            if (matrix.getElement(n2, i) == (double)(i == n ? 1 : 0)) continue;
            return null;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (matrix.getElement(i, n) != 0.0) {
                return null;
            }
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                double d = matrix.getElement(i, j);
                if (d == 0.0) continue;
                if (d != 1.0 || bl) {
                    return null;
                }
                nArray[i] = j;
                bl = true;
            }
            if (bl) continue;
            return null;
        }
        return new CopyTransform(n, nArray);
    }

    @Override
    public int getSourceDimensions() {
        return this.srcDim;
    }

    @Override
    public int getTargetDimensions() {
        return this.indices.length;
    }

    @Override
    public boolean isAffine() {
        return this.srcDim == this.indices.length;
    }

    @Override
    public boolean isIdentity() {
        if (this.srcDim != this.indices.length) {
            return false;
        }
        int n = this.indices.length;
        while (--n >= 0) {
            if (this.indices[n] == n) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        this.transform(dArray, n, dArray2, n2, 1);
        return bl ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = this.indices;
        int n6 = n5 = this.srcDim;
        int n7 = n4 = nArray.length;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        if (dArray != dArray2) {
            while (--n3 >= 0) {
                for (int i = 0; i < n4; ++i) {
                    dArray2[n2++] = dArray[n + nArray[i]];
                }
                n += n5;
            }
        } else {
            double[] dArray3 = new double[n4];
            while (--n3 >= 0) {
                for (int i = 0; i < n4; ++i) {
                    dArray3[i] = dArray[n + nArray[i]];
                }
                System.arraycopy(dArray3, 0, dArray2, n2, n4);
                n += n6;
                n2 += n7;
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = this.indices;
        int n6 = n5 = this.srcDim;
        int n7 = n4 = nArray.length;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        if (fArray != fArray2) {
            while (--n3 >= 0) {
                for (int i = 0; i < n4; ++i) {
                    fArray2[n2++] = fArray[n + nArray[i]];
                }
                n += n5;
            }
        } else {
            float[] fArray3 = new float[n4];
            while (--n3 >= 0) {
                for (int i = 0; i < n4; ++i) {
                    fArray3[i] = fArray[n + nArray[i]];
                }
                System.arraycopy(fArray3, 0, fArray2, n2, n4);
                n += n6;
                n2 += n7;
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        int[] nArray = this.indices;
        int n4 = this.srcDim;
        int n5 = nArray.length;
        while (--n3 >= 0) {
            for (int i = 0; i < n5; ++i) {
                fArray[n2++] = (float)dArray[n + nArray[i]];
            }
            n += n4;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        int[] nArray = this.indices;
        int n4 = this.srcDim;
        int n5 = nArray.length;
        while (--n3 >= 0) {
            for (int i = 0; i < n5; ++i) {
                dArray[n2++] = fArray[n + nArray[i]];
            }
            n += n4;
        }
    }

    @Override
    public double getElement(int n, int n2) {
        return (n == this.indices.length ? this.srcDim : this.indices[n]) == n2 ? 1.0 : 0.0;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        MatrixSIS matrixSIS = Matrices.createZero(this.indices.length, this.srcDim);
        for (int i = 0; i < this.indices.length; ++i) {
            matrixSIS.setElement(i, this.indices[i], 1.0);
        }
        return matrixSIS;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            int n = this.srcDim;
            int n2 = this.indices.length;
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            int n3 = n2;
            while (--n3 >= 0) {
                nArray[this.indices[n3]] = n3;
            }
            n3 = n;
            while (--n3 >= 0) {
                if (nArray[n3] >= 0) continue;
                MatrixSIS matrixSIS = Matrices.createZero(n + 1, n2 + 1);
                for (n3 = 0; n3 < n; ++n3) {
                    int n4 = nArray[n3];
                    if (n4 >= 0) {
                        matrixSIS.setElement(n3, n4, 1.0);
                        continue;
                    }
                    matrixSIS.setElement(n3, n2, Double.NaN);
                }
                matrixSIS.setElement(n, n2, 1.0);
                this.inverse = MathTransforms.linear(matrixSIS);
                if (this.inverse instanceof ProjectiveTransform) {
                    ((ProjectiveTransform)this.inverse).inverse = this;
                }
                return this.inverse;
            }
            CopyTransform copyTransform = this;
            if (!Arrays.equals(nArray, this.indices)) {
                copyTransform = new CopyTransform(this.indices.length, nArray);
                copyTransform.inverse = this;
            }
            this.inverse = copyTransform;
        }
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.indices) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        CopyTransform copyTransform = (CopyTransform)object;
        return this.srcDim == copyTransform.srcDim && Arrays.equals(this.indices, copyTransform.indices);
    }
}

