/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.util.LazySet;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OperationMethodSet;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultMathTransformFactory
extends AbstractFactory
implements MathTransformFactory,
Parser {
    private static final double ELLIPSOID_PRECISION = 0.01;
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Iterable<? extends OperationMethod> methods;
    private final ConcurrentMap<String, OperationMethod> methodsByName;
    private final Map<Class<?>, OperationMethodSet> methodsByType;
    private final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final AtomicReference<Parser> parser;

    public DefaultMathTransformFactory() {
        this(new LazySet<OperationMethod>(ServiceLoader.load(OperationMethod.class).iterator()));
    }

    public DefaultMathTransformFactory(Iterable<? extends OperationMethod> iterable) {
        ArgumentChecks.ensureNonNull("methods", iterable);
        this.methods = iterable;
        this.methodsByName = new ConcurrentHashMap<String, OperationMethod>();
        this.methodsByType = new IdentityHashMap();
        this.lastMethod = new ThreadLocal();
        this.pool = new WeakHashSet<MathTransform>(MathTransform.class);
        this.parser = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> clazz) {
        Object object;
        ArgumentChecks.ensureNonNull("type", clazz);
        Object object2 = this.methodsByType;
        synchronized (object2) {
            object = this.methodsByType.get(clazz);
        }
        if (object == null) {
            object2 = this.methods;
            synchronized (object2) {
                object = new OperationMethodSet(clazz, this.methods);
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                object2 = JDK8.putIfAbsent(this.methodsByType, clazz, object);
            }
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    public OperationMethod getOperationMethod(String string) throws NoSuchIdentifierException {
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("identifier", string);
        OperationMethod operationMethod = (OperationMethod)this.methodsByName.get(string);
        if (operationMethod == null) {
            operationMethod = ReferencingServices.getInstance().getOperationMethod(this.methods, string);
            if (operationMethod == null) {
                throw new NoSuchIdentifierException(Errors.format((short)179, string), string);
            }
            OperationMethod operationMethod2 = this.methodsByName.putIfAbsent(string.intern(), operationMethod);
            if (operationMethod2 != null) {
                operationMethod = operationMethod2;
            }
        }
        return operationMethod;
    }

    @Override
    public ParameterValueGroup getDefaultParameters(String string) throws NoSuchIdentifierException {
        return this.getOperationMethod(string).getParameters().createValue();
    }

    private static double getValue(ParameterValue<?> parameterValue, Unit<Length> unit) {
        return parameterValue.getValue() != null ? parameterValue.doubleValue(unit) : Double.NaN;
    }

    private static boolean ensureSet(ParameterValue<?> parameterValue, double d, double d2, Unit<?> unit, double d3) {
        if (Math.abs(d - d2) <= d3) {
            return false;
        }
        if (Double.isNaN(d)) {
            parameterValue.setValue(d2, unit);
            return false;
        }
        return true;
    }

    @Override
    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, ParameterValueGroup parameterValueGroup, CoordinateSystem coordinateSystem) throws NoSuchIdentifierException, FactoryException {
        Object object;
        ArgumentChecks.ensureNonNull("baseCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        ArgumentChecks.ensureNonNull("derivedCS", coordinateSystem);
        RuntimeException runtimeException = null;
        Ellipsoid ellipsoid = ReferencingUtilities.getEllipsoidOfGeographicCRS(coordinateReferenceSystem);
        if (ellipsoid != null) {
            boolean bl;
            Object object2;
            object = null;
            double d = 0.0;
            try {
                ParameterValue<?> parameterValue = parameterValueGroup.parameter("semi_major");
                object2 = parameterValueGroup.parameter("semi_minor");
                Unit<Length> unit = ellipsoid.getAxisUnit();
                double d2 = DefaultMathTransformFactory.getValue(parameterValue, unit);
                double d3 = DefaultMathTransformFactory.getValue(object2, unit);
                double d4 = SI.METRE.getConverterTo(unit).convert(0.01);
                if (DefaultMathTransformFactory.ensureSet(parameterValue, d2, ellipsoid.getSemiMajorAxis(), unit, d4)) {
                    object = parameterValue;
                    d = d2;
                }
                if (DefaultMathTransformFactory.ensureSet(object2, d3, ellipsoid.getSemiMinorAxis(), unit, d4)) {
                    object = object2;
                    d = d3;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                runtimeException = illegalArgumentException;
            }
            catch (IllegalStateException illegalStateException) {
                runtimeException = illegalStateException;
            }
            if (object != null) {
                object2 = Messages.getResources(null).getLogRecord(Level.WARNING, (short)9, ellipsoid.getName().getCode(), object.getDescriptor().getName().getCode(), d);
                ((LogRecord)object2).setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(DefaultMathTransformFactory.class, "createBaseToDerived", (LogRecord)object2);
                bl = false;
            } else {
                bl = ellipsoid.isIvfDefinitive();
            }
            if (bl) {
                try {
                    parameterValueGroup.parameter("inverse_flattening").setValue(ellipsoid.getInverseFlattening());
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultMathTransformFactory.class, "createBaseToDerived", parameterNotFoundException);
                }
            }
        }
        try {
            object = this.createParameterizedTransform(parameterValueGroup);
            OperationMethod operationMethod = this.lastMethod.get();
            object = this.createBaseToDerived(coordinateReferenceSystem.getCoordinateSystem(), (MathTransform)object, coordinateSystem);
            this.lastMethod.set(operationMethod);
        }
        catch (FactoryException factoryException) {
            if (runtimeException != null) {
                // empty if block
            }
            throw factoryException;
        }
        return object;
    }

    public MathTransform createBaseToDerived(CoordinateSystem coordinateSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem2) throws FactoryException {
        Object object;
        int n;
        int n2;
        Matrix matrix;
        Matrix matrix2;
        ArgumentChecks.ensureNonNull("baseCS", coordinateSystem);
        ArgumentChecks.ensureNonNull("parameterized", mathTransform);
        ArgumentChecks.ensureNonNull("derivedCS", coordinateSystem2);
        try {
            matrix2 = CoordinateSystems.swapAndScaleAxes(coordinateSystem, CoordinateSystems.replaceAxes(coordinateSystem, AxesConvention.NORMALIZED));
            matrix = CoordinateSystems.swapAndScaleAxes(CoordinateSystems.replaceAxes(coordinateSystem2, AxesConvention.NORMALIZED), coordinateSystem2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new FactoryException(conversionException);
        }
        MathTransform mathTransform2 = this.createAffineTransform(matrix2);
        MathTransform mathTransform3 = this.createAffineTransform(matrix);
        MathTransform mathTransform4 = mathTransform;
        int n3 = mathTransform3.getSourceDimensions() - mathTransform4.getTargetDimensions();
        if (n3 > 0) {
            mathTransform4 = this.createPassThroughTransform(0, mathTransform4, n3);
        }
        if ((n2 = mathTransform2.getTargetDimensions()) > (n = mathTransform4.getSourceDimensions())) {
            object = Matrices.createDiagonal(n + 1, n2 + 1);
            object.setElement(n, n2, 1.0);
            mathTransform2 = this.createConcatenatedTransform(this.createAffineTransform((Matrix)object), mathTransform2);
        }
        object = this.createConcatenatedTransform(this.createConcatenatedTransform(mathTransform2, mathTransform4), mathTransform3);
        if (mathTransform instanceof ParameterizedAffine && !(object instanceof ParameterizedAffine)) {
            object = ((ParameterizedAffine)mathTransform).newTransform((MathTransform)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup) throws NoSuchIdentifierException, FactoryException {
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        String string = parameterValueGroup.getDescriptor().getName().getCode();
        OperationMethod operationMethod = null;
        try {
            MathTransform mathTransform;
            operationMethod = this.getOperationMethod(string);
            if (!(operationMethod instanceof MathTransformProvider)) {
                throw new NoSuchIdentifierException(Errors.format((short)127, Classes.getClass(operationMethod)), string);
            }
            try {
                mathTransform = ((MathTransformProvider)((Object)operationMethod)).createMathTransform(this, parameterValueGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FactoryException(illegalArgumentException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new FactoryException(illegalStateException);
            }
            mathTransform = this.unique(mathTransform);
            operationMethod = DefaultOperationMethod.redimension(operationMethod, mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions());
            MathTransform mathTransform2 = mathTransform;
            return mathTransform2;
        }
        finally {
            this.lastMethod.set(operationMethod);
        }
    }

    @Override
    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.unique(MathTransforms.linear(matrix));
    }

    @Override
    public MathTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        MathTransform mathTransform3;
        this.lastMethod.remove();
        try {
            mathTransform3 = MathTransforms.concatenate(mathTransform, mathTransform2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        return this.unique(mathTransform3);
    }

    @Override
    public MathTransform createPassThroughTransform(int n, MathTransform mathTransform, int n2) throws FactoryException {
        MathTransform mathTransform2;
        this.lastMethod.remove();
        try {
            mathTransform2 = PassThroughTransform.create(n, mathTransform, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        return this.unique(mathTransform2);
    }

    @Override
    public MathTransform createFromXML(String string) throws FactoryException {
        this.lastMethod.remove();
        throw new FactoryException("Not yet implemented.");
    }

    @Override
    public MathTransform createFromWKT(String string) throws FactoryException {
        Constructor<Parser> constructor;
        this.lastMethod.remove();
        Parser parser = this.parser.getAndSet(null);
        if (parser == null) {
            try {
                constructor = parserConstructor;
                if (constructor == null) {
                    constructor = Class.forName("org.apache.sis.io.wkt.MathTransformParser").asSubclass(Parser.class).getConstructor(MathTransformFactory.class);
                    constructor.setAccessible(true);
                    parserConstructor = constructor;
                }
                parser = (Parser)constructor.newInstance(this);
            }
            catch (Exception exception) {
                throw new FactoryException(exception);
            }
        }
        constructor = parser.createFromWKT(string);
        this.parser.set(parser);
        return (MathTransform)((Object)constructor);
    }

    private MathTransform unique(MathTransform mathTransform) {
        return this.pool.unique(mathTransform);
    }

    @Override
    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            this.methodsByName.clear();
            Iterable<? extends OperationMethod> iterable2 = this.methods;
            if (iterable2 instanceof LazySet) {
                ((LazySet)iterable2).reload();
                iterable2 = ((LazySet)iterable2).source;
            }
            if (iterable2 instanceof ServiceLoader) {
                ((ServiceLoader)iterable2).reload();
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                for (OperationMethodSet operationMethodSet : this.methodsByType.values()) {
                    operationMethodSet.reset();
                }
            }
            this.pool.clear();
        }
    }
}

