/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.cache.TemplateLoaderUtils;
import freemarker.template.utility.StringUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringTemplateLoader
implements TemplateLoader {
    private final Map<String, StringTemplateSource> templates = new HashMap<String, StringTemplateSource>();

    public void putTemplate(String name, String templateSource) {
        this.putTemplate(name, templateSource, System.currentTimeMillis());
    }

    public void putTemplate(String name, String templateSource, long lastModified) {
        this.templates.put(name, new StringTemplateSource(name, templateSource, lastModified));
    }

    public boolean removeTemplate(String name) {
        return this.templates.remove(name) != null;
    }

    public void closeTemplateSource(Object templateSource) {
    }

    public Object findTemplateSource(String name) {
        return this.templates.get(name);
    }

    public long getLastModified(Object templateSource) {
        return ((StringTemplateSource)templateSource).lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) {
        return new StringReader(((StringTemplateSource)templateSource).source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TemplateLoaderUtils.getClassNameForToString(this));
        sb.append("(Map { ");
        int cnt = 0;
        Iterator<String> it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            if (++cnt != 1) {
                sb.append(", ");
            }
            if (cnt > 10) {
                sb.append("...");
                break;
            }
            sb.append(StringUtil.jQuote((Object)it.next()));
            sb.append("=...");
        }
        if (cnt != 0) {
            sb.append(' ');
        }
        sb.append("})");
        return sb.toString();
    }

    private static class StringTemplateSource {
        private final String name;
        private final String source;
        private final long lastModified;

        StringTemplateSource(String name, String source, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (source == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = name;
            this.source = source;
            this.lastModified = lastModified;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringTemplateSource) {
                return this.name.equals(((StringTemplateSource)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

