/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.drools.kproject.File;
import org.drools.kproject.FileSystem;
import org.drools.kproject.Folder;
import org.drools.kproject.GenerateKBaseProjectFiles;
import org.drools.kproject.KBase;
import org.drools.kproject.KProject;
import org.drools.kproject.KSession;

public class ProjectWriter {
    private FileSystem fs;

    public ProjectWriter(FileSystem fs) {
        this.fs = fs;
    }

    public void write(KProject kproject) {
        this.writeKBasePaths(kproject);
        this.writerKProject(kproject);
        this.writerKBases(kproject);
        this.writerKBaseProducers(kproject);
    }

    public void writeKBasePaths(KProject kproject) {
        Properties props = new Properties();
        props.setProperty("kproject", kproject.getKProjectPath());
        try {
            ProjectWriter.saveProperties(this.fs.getProjectFolder().getFile("kbasePaths.properties"), props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writerKProject(KProject kproject) {
        Object[] kbases = kproject.getKBases().keySet().toArray(new String[kproject.getKBases().size()]);
        Arrays.sort(kbases);
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        for (Object kbaseQName : kbases) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append((String)kbaseQName);
            first = false;
        }
        Properties props = new Properties();
        props.setProperty("kbaseEntries", sbuilder.toString());
        try {
            Folder f = this.fs.getFolder(kproject.getKProjectPath());
            f.create();
            File file = f.getFile("kproject.properties");
            ProjectWriter.saveProperties(file, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writerKBases(KProject kproject) {
        Object[] kbases = kproject.getKBases().keySet().toArray(new String[kproject.getKBases().size()]);
        Arrays.sort(kbases);
        for (Object kbaseQName : kbases) {
            this.writeKBase(kproject, (String)kbaseQName);
        }
    }

    private void writeKBase(KProject kproject, String kbaseQName) {
        KBase kbase = kproject.getKBases().get(kbaseQName);
        Folder kbasePath = null;
        Properties props = new Properties();
        props.setProperty("namespace", kbase.getNamespace());
        props.setProperty("name", kbase.getName());
        props.setProperty("eventProcessingMode", kbase.getEventProcessingMode().toExternalForm());
        props.setProperty("equalsBehavior", kbase.getEqualsBehavior().toString());
        Collections.sort(kbase.getAnnotations());
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        for (String str : kbase.getAnnotations()) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append(str);
            first = false;
        }
        props.setProperty("annotations", sbuilder.toString());
        ArrayList<String> files = new ArrayList<String>(kbase.getFiles().size());
        for (String file : kbase.getFiles()) {
            files.add(this.fs.getFile(file).getPath().toRelativePortableString(kbasePath.getPath()));
        }
        Collections.sort(files);
        sbuilder = new StringBuilder();
        first = true;
        for (String file : files) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append(file);
            first = false;
        }
        props.setProperty("files", sbuilder.toString());
        ArrayList<String> ksessions = new ArrayList<String>(kbase.getKSessions().keySet());
        Collections.sort(ksessions);
        sbuilder = new StringBuilder();
        first = true;
        for (String ksessionQName : ksessions) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append(ksessionQName);
            this.writeKSession(ksessionQName, kbase, kproject, props);
            first = false;
        }
        props.setProperty("ksessions", sbuilder.toString());
        try {
            kbasePath.create();
            ProjectWriter.saveProperties(kbasePath.getFile(kbase.getQName() + ".properties"), props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeKSession(String ksessionQName, KBase kbase, KProject kproject, Properties props) {
        KSession ksession = kbase.getKSessions().get(ksessionQName);
        props.setProperty(ksessionQName + ".namespace", ksession.getNamespace());
        props.setProperty(ksessionQName + ".name", ksession.getName());
        props.setProperty(ksessionQName + ".type", ksession.getType());
        props.setProperty(ksessionQName + ".clockType", ksession.getClockType().toString());
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        for (String str : kbase.getAnnotations()) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append(str);
            first = false;
        }
        props.setProperty(ksessionQName + ".annotations", sbuilder.toString());
    }

    public void writerKBaseProducers(KProject kproject) {
        Object[] kbases = kproject.getKBases().keySet().toArray(new String[kproject.getKBases().size()]);
        Arrays.sort(kbases);
        try {
            for (Object kbaseQName : kbases) {
                this.writeKBaseProducer(kproject.getKBases().get(kbaseQName), kproject);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeKBaseProducer(KBase kbase, KProject kproject) throws IOException {
        Folder folder = null;
        String s = GenerateKBaseProjectFiles.generateProducer(kbase);
        folder = folder.getFolder(kbase.getNamespace().replace('.', '/'));
        folder.create();
        File file = folder.getFile(kbase.getName() + "Producer.java");
        if (file.exists()) {
            file.setContents(new ByteArrayInputStream(s.getBytes()));
        } else {
            file.create(new ByteArrayInputStream(s.getBytes()));
        }
        s = GenerateKBaseProjectFiles.generateQualifier(kbase);
        file = folder.getFile(kbase.getName() + ".java");
        if (file.exists()) {
            file.setContents(new ByteArrayInputStream(s.getBytes()));
        } else {
            file.create(new ByteArrayInputStream(s.getBytes()));
        }
    }

    public void writerKSessionProducers(KBase kbase, KProject kproject) {
        Object[] kbases = kproject.getKBases().keySet().toArray(new String[kproject.getKBases().size()]);
        Arrays.sort(kbases);
        try {
            for (Object kbaseQName : kbases) {
                this.writeKBaseProducer(kproject.getKBases().get(kbaseQName), kproject);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveProperties(File file, Properties props) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (file.exists()) {
            file.setContents(new ByteArrayInputStream(baos.toByteArray()));
        } else {
            file.create(new ByteArrayInputStream(baos.toByteArray()));
        }
    }
}

