/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.WorkingSetEditor;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.factconstraints.helper.CustomFormsContainer;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class CustomFormsEditorPanel
extends Composite {
    private ListBox factsCombo = new ListBox(false);
    private ListBox fieldsCombo = new ListBox(false);
    private TextBox customFormURL = new TextBox();
    private TextBox customFormWidth = new TextBox();
    private TextBox customFormHeight = new TextBox();
    private boolean validFactsChanged = true;
    private Map<String, ConstraintConfiguration> contraintsMap = new HashMap<String, ConstraintConfiguration>();
    private final Asset workingSet;
    private final WorkingSetEditor workingSetEditor;

    public CustomFormsEditorPanel(final WorkingSetEditor workingSetEditor) {
        this.workingSetEditor = workingSetEditor;
        this.workingSet = workingSetEditor.getWorkingSet();
        this.factsCombo.setVisibleItemCount(1);
        this.fieldsCombo.setVisibleItemCount(1);
        this.customFormURL.setWidth("400px");
        this.customFormURL.setTitle("Leave it blank if you want to remove the Custom Form URL");
        this.customFormHeight.setWidth("50px");
        this.customFormWidth.setWidth("50px");
        this.factsCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CustomFormsEditorPanel.this.fillSelectedFactFields();
            }
        });
        this.fieldsCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CustomFormsEditorPanel.this.fillFieldConstrains();
            }
        });
        FlexTable table = new FlexTable();
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(Constants.INSTANCE.FactTypes()));
        vp.add((Widget)this.factsCombo);
        table.setWidget(0, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(Constants.INSTANCE.Field()));
        vp.add((Widget)this.fieldsCombo);
        table.setWidget(1, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel("Custom Form URL:"));
        Button btnUpdateURL = new Button(Constants.INSTANCE.OK(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                int h;
                int w;
                try {
                    w = Integer.parseInt(CustomFormsEditorPanel.this.customFormWidth.getText());
                    h = Integer.parseInt(CustomFormsEditorPanel.this.customFormHeight.getText());
                }
                catch (NumberFormatException ex) {
                    Window.alert((String)"Width and Height must be integer values!");
                    return;
                }
                if (((WorkingSetConfigData)((CustomFormsEditorPanel)CustomFormsEditorPanel.this).workingSet.getContent()).customForms == null) {
                    ((WorkingSetConfigData)((CustomFormsEditorPanel)CustomFormsEditorPanel.this).workingSet.getContent()).customForms = new ArrayList<CustomFormConfiguration>();
                }
                String factType = CustomFormsEditorPanel.this.factsCombo.getItemText(CustomFormsEditorPanel.this.factsCombo.getSelectedIndex());
                String fieldName = CustomFormsEditorPanel.this.fieldsCombo.getItemText(CustomFormsEditorPanel.this.fieldsCombo.getSelectedIndex());
                CustomFormConfiguration newCustomFormConfiguration = CustomFormsContainer.getEmptyCustomFormConfiguration();
                newCustomFormConfiguration.setFactType(factType);
                newCustomFormConfiguration.setFieldName(fieldName);
                newCustomFormConfiguration.setCustomFormURL(CustomFormsEditorPanel.this.customFormURL.getText());
                newCustomFormConfiguration.setCustomFormWidth(w);
                newCustomFormConfiguration.setCustomFormHeight(h);
                workingSetEditor.getCustomFormsContainer().putCustomForm(newCustomFormConfiguration);
                ((WorkingSetConfigData)((CustomFormsEditorPanel)CustomFormsEditorPanel.this).workingSet.getContent()).customForms = workingSetEditor.getCustomFormsContainer().getCustomForms();
            }
        });
        vp.add((Widget)this.customFormURL);
        vp.add((Widget)new SmallLabel("Width:"));
        vp.add((Widget)this.customFormWidth);
        vp.add((Widget)new SmallLabel("Height:"));
        vp.add((Widget)this.customFormHeight);
        table.setWidget(2, 0, (Widget)vp);
        table.setWidget(3, 0, (Widget)btnUpdateURL);
        this.fillSelectedFacts();
        this.fillSelectedFactFields();
        this.fillFieldConstrains();
        this.initWidget((Widget)table);
    }

    protected final void fillSelectedFacts() {
        if (this.validFactsChanged) {
            String s = this.factsCombo.getSelectedIndex() != -1 ? this.factsCombo.getItemText(this.factsCombo.getSelectedIndex()) : "";
            this.factsCombo.clear();
            this.validFactsChanged = false;
            for (int i = 0; i < this.workingSetEditor.getValidFactsListBox().getItemCount(); ++i) {
                String itemText = this.workingSetEditor.getValidFactsListBox().getItemText(i);
                this.factsCombo.addItem(itemText);
                if (!s.equals(itemText)) continue;
                this.factsCombo.setSelectedIndex(i);
            }
            if (this.factsCombo.getSelectedIndex() == -1 && this.factsCombo.getItemCount() > 0) {
                this.factsCombo.setSelectedIndex(0);
            }
            this.fillSelectedFactFields();
        }
    }

    private void fillSelectedFactFields() {
        if (this.factsCombo.getSelectedIndex() != -1) {
            String fact = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.fieldsCombo.clear();
            for (String field : this.getCompletionEngine().getFieldCompletions(fact)) {
                this.fieldsCombo.addItem(field);
            }
        }
        if (this.fieldsCombo.getSelectedIndex() == -1 && this.fieldsCombo.getItemCount() > 0) {
            this.fieldsCombo.setSelectedIndex(0);
        }
        this.fillFieldConstrains();
    }

    private void fillFieldConstrains() {
        if (this.fieldsCombo.getSelectedIndex() >= 0 && this.factsCombo.getSelectedIndex() >= 0) {
            String fieldName = this.fieldsCombo.getItemText(this.fieldsCombo.getSelectedIndex());
            String factField = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.contraintsMap.clear();
            if (this.workingSetEditor.getCustomFormsContainer().containsCustomFormFor(factField, fieldName)) {
                CustomFormConfiguration customForm = this.workingSetEditor.getCustomFormsContainer().getCustomForm(factField, fieldName);
                this.customFormURL.setText(customForm.getCustomFormURL());
                this.customFormWidth.setText(String.valueOf(customForm.getCustomFormWidth()));
                this.customFormHeight.setText(String.valueOf(customForm.getCustomFormHeight()));
            } else {
                this.customFormURL.setText("");
                this.customFormWidth.setText("");
                this.customFormHeight.setText("");
            }
        }
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return SuggestionCompletionCache.getInstance().getEngineFromCache(this.workingSet.getMetaData().getModuleName());
    }

    public void notifyValidFactsChanged() {
        this.validFactsChanged = true;
    }
}

