/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.DynamicTextArea;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.FreeFormLinePopup;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;

public class FreeFormLineWidget
extends RuleModellerWidget {
    private FreeFormLine action;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private DynamicTextArea textArea = new DynamicTextArea();
    private boolean readOnly;

    public FreeFormLineWidget(RuleModeller mod, EventBus eventBus, FreeFormLine p) {
        this(mod, eventBus, p, null);
    }

    public FreeFormLineWidget(RuleModeller mod, EventBus eventBus, FreeFormLine p, Boolean readOnly) {
        super(mod, eventBus);
        this.action = p;
        this.readOnly = readOnly == null ? false : readOnly;
        this.textArea.setMaxLines(5);
        this.layout.setWidget(0, 0, this.createTextBox());
        this.layout.setWidget(0, 1, this.createEditIcon());
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_BOTTOM);
        formatter.setWidth(0, 0, "1px");
        formatter.setAlignment(0, 1, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_TOP);
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.initWidget((Widget)this.layout);
    }

    private Widget createTextBox() {
        this.textArea.setTitle(Constants.INSTANCE.ThisIsADrlExpressionFreeForm());
        this.textArea.setText(this.action.text);
        this.textArea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ((FreeFormLineWidget)FreeFormLineWidget.this).action.text = FreeFormLineWidget.this.textArea.getText();
                FreeFormLineWidget.this.setModified(true);
            }
        });
        return this.textArea;
    }

    private Widget createEditIcon() {
        Image btn;
        if (!this.readOnly) {
            btn = GuvnorImages.INSTANCE.Edit();
            btn.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final FreeFormLinePopup popup = new FreeFormLinePopup(Constants.INSTANCE.FreeFormDrl(), ((FreeFormLineWidget)FreeFormLineWidget.this).action.text);
                    popup.addOKClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            ((FreeFormLineWidget)FreeFormLineWidget.this).action.text = popup.getText();
                            FreeFormLineWidget.this.textArea.setText(((FreeFormLineWidget)FreeFormLineWidget.this).action.text);
                            FreeFormLineWidget.this.setModified(true);
                            popup.hide();
                        }
                    });
                    popup.show();
                }
            });
        } else {
            btn = new Image(DroolsGuvnorImageResources.INSTANCE.editDisabled());
        }
        return btn;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return true;
    }
}

