/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.events.SetInternalTemplateDataModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ColumnResizeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetInternalModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SortDataEvent;
import org.drools.guvnor.client.widgets.tables.SortDirection;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;

public class TemplateDataHeaderWidget
extends AbstractDecoratedGridHeaderWidget<TemplateModel, TemplateDataColumn> {
    private HeaderWidget widget;

    public TemplateDataHeaderWidget(ResourcesProvider<TemplateDataColumn> resources, boolean isReadOnly, EventBus eventBus) {
        super(resources, isReadOnly, eventBus);
        eventBus.addHandler(SetInternalTemplateDataModelEvent.TYPE, (EventHandler)this);
    }

    @Override
    public void redraw() {
        this.widget.redraw();
    }

    @Override
    public void setScrollPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be null");
        }
        ((ScrollPanel)this.panel).setHorizontalScrollPosition(position);
    }

    @Override
    protected void resizeColumn(DynamicColumn<TemplateDataColumn> resizeColumn, int resizeColumnWidth) {
        resizeColumn.setWidth(resizeColumnWidth);
        int resizeColumnIndex = this.widget.headerColumns.indexOf(resizeColumn);
        TableCellElement tce = (TableCellElement)this.widget.headerRows[0].getChild(resizeColumnIndex).cast();
        DivElement div = (DivElement)tce.getFirstChild().cast();
        div.getStyle().setWidth((double)resizeColumnWidth, Style.Unit.PX);
        tce = (TableCellElement)this.widget.headerRows[1].getChild(resizeColumnIndex).cast();
        div = (DivElement)tce.getFirstChild().cast();
        div.getStyle().setWidth((double)resizeColumnWidth, Style.Unit.PX);
        ColumnResizeEvent cre = new ColumnResizeEvent((DynamicColumn)this.widget.headerColumns.get(resizeColumnIndex), resizeColumnWidth);
        this.eventBus.fireEvent((GwtEvent)cre);
    }

    @Override
    protected Widget getHeaderWidget() {
        if (this.widget == null) {
            this.widget = new HeaderWidget();
        }
        return this.widget;
    }

    @Override
    protected AbstractDecoratedGridHeaderWidget.ResizerInformation getResizerInformation(int mx) {
        boolean isPrimed = false;
        AbstractDecoratedGridHeaderWidget.ResizerInformation resizerInfo = new AbstractDecoratedGridHeaderWidget.ResizerInformation(this);
        for (int iCol = 0; iCol < this.widget.headerRows[0].getChildCount(); ++iCol) {
            TableCellElement tce = (TableCellElement)this.widget.headerRows[0].getChild(iCol).cast();
            int cx = tce.getAbsoluteRight();
            if (Math.abs(mx - cx) > 5) continue;
            isPrimed = true;
            resizerInfo.setResizePrimed(isPrimed);
            resizerInfo.setResizeColumn((DynamicColumn)this.widget.headerColumns.get(iCol));
            resizerInfo.setResizeColumnLeft(tce.getAbsoluteLeft());
            break;
        }
        if (isPrimed) {
            this.setCursorType(Style.Cursor.COL_RESIZE);
        } else {
            this.setCursorType(Style.Cursor.DEFAULT);
        }
        return resizerInfo;
    }

    private void setCursorType(Style.Cursor cursor) {
        for (int iRow = 0; iRow < this.widget.headerRows.length; ++iRow) {
            TableRowElement tre = (TableRowElement)this.widget.headerRows[iRow].cast();
            for (int iCol = 0; iCol < tre.getCells().getLength(); ++iCol) {
                TableCellElement tce = (TableCellElement)tre.getCells().getItem(iCol);
                tce.getStyle().setCursor(cursor);
            }
        }
    }

    @Override
    public void onSetInternalModel(SetInternalModelEvent<TemplateModel, TemplateDataColumn> event) {
        this.sortableColumns.clear();
        this.model = event.getModel();
        List<DynamicColumn<TemplateDataColumn>> columns = event.getColumns();
        for (DynamicColumn<TemplateDataColumn> column : columns) {
            this.sortableColumns.add(column);
        }
        this.redraw();
    }

    private class HeaderWidget
    extends CellPanel {
        private List<HeaderSorter> sorters = new ArrayList<HeaderSorter>();
        private Element[] headerRows = new Element[2];
        private List<DynamicColumn<TemplateDataColumn>> headerColumns = new ArrayList<DynamicColumn<TemplateDataColumn>>();

        private HeaderWidget() {
            for (int iRow = 0; iRow < this.headerRows.length; ++iRow) {
                this.headerRows[iRow] = DOM.createTR();
                this.getBody().appendChild((Node)this.headerRows[iRow]);
            }
            ((TableElement)this.getBody().getParentElement().cast()).setCellSpacing(0);
            ((TableElement)this.getBody().getParentElement().cast()).setCellPadding(0);
        }

        private Element makeLabel(String text, int width, int height) {
            Element div = DOM.createDiv();
            div.getStyle().setWidth((double)width, Style.Unit.PX);
            div.getStyle().setHeight((double)height, Style.Unit.PX);
            div.getStyle().setOverflow(Style.Overflow.HIDDEN);
            div.setInnerText(text);
            return div;
        }

        private void populateTableCellElement(DynamicColumn<TemplateDataColumn> col, Element tce) {
            TemplateDataColumn modelCol = col.getModelColumn();
            tce.appendChild((Node)this.makeLabel(modelCol.getTemplateVar(), col.getWidth(), TemplateDataHeaderWidget.this.resources.rowHeaderHeight()));
            tce.addClassName(TemplateDataHeaderWidget.this.resources.headerRowIntermediate());
        }

        private void redraw() {
            for (HeaderSorter sorter : this.sorters) {
                this.remove((Widget)sorter);
            }
            this.sorters.clear();
            this.headerColumns.clear();
            for (int iCol = 0; iCol < TemplateDataHeaderWidget.this.sortableColumns.size(); ++iCol) {
                DynamicColumn col = (DynamicColumn)TemplateDataHeaderWidget.this.sortableColumns.get(iCol);
                this.headerColumns.add(col);
            }
            for (int iRow = 0; iRow < this.headerRows.length; ++iRow) {
                this.redrawHeaderRow(iRow);
            }
            Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                public void execute() {
                    ResizeEvent.fire((HasResizeHandlers)TemplateDataHeaderWidget.this, (int)TemplateDataHeaderWidget.this.widget.getOffsetWidth(), (int)TemplateDataHeaderWidget.this.widget.getOffsetHeight());
                }
            });
        }

        private void redrawHeaderRow(int iRow) {
            Element tce = null;
            Element tre = DOM.createTR();
            switch (iRow) {
                case 0: {
                    for (DynamicColumn<TemplateDataColumn> col : this.headerColumns) {
                        tce = DOM.createTD();
                        tce.addClassName(TemplateDataHeaderWidget.this.resources.headerText());
                        tre.appendChild((Node)tce);
                        this.populateTableCellElement(col, tce);
                    }
                    break;
                }
                case 1: {
                    for (DynamicColumn<TemplateDataColumn> col : this.headerColumns) {
                        HeaderSorter shp = new HeaderSorter(col);
                        final DynamicColumn<TemplateDataColumn> sortableColumn = col;
                        if (!TemplateDataHeaderWidget.this.isReadOnly) {
                            shp.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    if (sortableColumn.isSortable()) {
                                        HeaderWidget.this.updateSortOrder(sortableColumn);
                                        SortDataEvent sde = new SortDataEvent(TemplateDataHeaderWidget.this.getSortConfiguration());
                                        TemplateDataHeaderWidget.this.eventBus.fireEvent((GwtEvent)sde);
                                    }
                                }
                            });
                        }
                        this.sorters.add(shp);
                        tce = DOM.createTD();
                        tce.addClassName(TemplateDataHeaderWidget.this.resources.headerRowBottom());
                        tre.appendChild((Node)tce);
                        this.add((Widget)shp, tce);
                    }
                    break;
                }
            }
            this.getBody().replaceChild((Node)tre, (Node)this.headerRows[iRow]);
            this.headerRows[iRow] = tre;
        }

        private void updateSortOrder(DynamicColumn<TemplateDataColumn> column) {
            if (column.getSortIndex() == 0) {
                if (column.getSortDirection() != SortDirection.ASCENDING) {
                    column.setSortDirection(SortDirection.ASCENDING);
                } else {
                    column.setSortDirection(SortDirection.DESCENDING);
                }
            } else {
                column.setSortIndex(0);
                column.setSortDirection(SortDirection.ASCENDING);
                int sortIndex = 1;
                for (DynamicColumn sortableColumn : TemplateDataHeaderWidget.this.sortableColumns) {
                    if (sortableColumn.equals(column) || sortableColumn.getSortDirection() == SortDirection.NONE) continue;
                    sortableColumn.setSortIndex(sortIndex);
                    ++sortIndex;
                }
            }
        }

        private class HeaderSorter
        extends FocusPanel {
            private final HorizontalPanel hp = new HorizontalPanel();
            private final DynamicColumn<TemplateDataColumn> col;

            private HeaderSorter(DynamicColumn<TemplateDataColumn> col) {
                this.col = col;
                this.hp.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
                this.hp.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
                this.hp.setHeight(TemplateDataHeaderWidget.this.resources.rowHeaderSorterHeight() + "px");
                this.hp.setWidth("100%");
                this.setIconImage();
                this.add((Widget)this.hp);
                col.addValueChangeHandler(new ValueChangeHandler<SortConfiguration>(){

                    public void onValueChange(ValueChangeEvent<SortConfiguration> event) {
                        HeaderSorter.this.setIconImage();
                    }
                });
            }

            private void setIconImage() {
                this.hp.clear();
                block0 : switch (this.col.getSortDirection()) {
                    case ASCENDING: {
                        switch (this.col.getSortIndex()) {
                            case 0: {
                                this.hp.add((Widget)new Image(TemplateDataHeaderWidget.this.resources.upArrowIcon()));
                                break block0;
                            }
                        }
                        this.hp.add((Widget)new Image(TemplateDataHeaderWidget.this.resources.smallUpArrowIcon()));
                        break;
                    }
                    case DESCENDING: {
                        switch (this.col.getSortIndex()) {
                            case 0: {
                                this.hp.add((Widget)new Image(TemplateDataHeaderWidget.this.resources.downArrowIcon()));
                                break block0;
                            }
                        }
                        this.hp.add((Widget)new Image(TemplateDataHeaderWidget.this.resources.smallDownArrowIcon()));
                        break;
                    }
                    default: {
                        this.hp.add((Widget)new Image(TemplateDataHeaderWidget.this.resources.arrowSpacerIcon()));
                    }
                }
            }
        }
    }
}

