/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis.condition;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetector;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class NumericConditionDetector
extends ConditionDetector<NumericConditionDetector> {
    private BigDecimal from = null;
    private boolean fromInclusive;
    private BigDecimal to = null;
    private boolean toInclusive;
    private List<BigDecimal> disallowedList = new ArrayList<BigDecimal>(1);

    public NumericConditionDetector(Pattern52 pattern, String factField, BigDecimal value, String operator) {
        super(pattern, factField);
        if (operator.equals("==")) {
            this.from = value;
            this.fromInclusive = true;
            this.to = value;
            this.toInclusive = true;
        } else if (operator.equals("!=")) {
            this.disallowedList.add(value);
        } else if (operator.equals("<")) {
            this.to = value;
            this.toInclusive = false;
        } else if (operator.equals("<=")) {
            this.to = value;
            this.toInclusive = true;
        } else if (operator.equals(">")) {
            this.from = value;
            this.fromInclusive = false;
        } else if (operator.equals(">=")) {
            this.from = value;
            this.fromInclusive = true;
        } else {
            this.hasUnrecognizedConstraint = true;
        }
    }

    public NumericConditionDetector(NumericConditionDetector a, NumericConditionDetector b) {
        super(a, b);
        int comparison;
        if (b.from == null) {
            this.from = a.from;
            this.fromInclusive = a.fromInclusive;
        } else if (a.from == null) {
            this.from = b.from;
            this.fromInclusive = b.fromInclusive;
        } else {
            comparison = a.from.compareTo(b.from);
            if (comparison < 0) {
                this.from = b.from;
                this.fromInclusive = b.fromInclusive;
            } else if (comparison == 0) {
                this.from = a.from;
                this.fromInclusive = a.fromInclusive && b.fromInclusive;
            } else {
                this.from = a.from;
                this.fromInclusive = a.fromInclusive;
            }
        }
        if (b.to == null) {
            this.to = a.to;
            this.toInclusive = a.toInclusive;
        } else if (a.to == null) {
            this.to = b.to;
            this.toInclusive = b.toInclusive;
        } else {
            comparison = a.to.compareTo(b.to);
            if (comparison < 0) {
                this.to = a.to;
                this.toInclusive = a.toInclusive;
            } else if (comparison == 0) {
                this.to = a.to;
                this.toInclusive = a.toInclusive && b.toInclusive;
            } else {
                this.to = b.to;
                this.toInclusive = b.toInclusive;
            }
        }
        this.disallowedList.addAll(a.disallowedList);
        this.disallowedList.addAll(b.disallowedList);
        this.optimizeNotList();
        this.detectImpossibleMatch();
    }

    private void optimizeNotList() {
        Iterator<BigDecimal> notIt = this.disallowedList.iterator();
        while (notIt.hasNext()) {
            int comparison;
            BigDecimal notValue = notIt.next();
            if (this.from != null) {
                comparison = notValue.compareTo(this.from);
                if (comparison <= 0) {
                    notIt.remove();
                }
                if (comparison == 0) {
                    this.fromInclusive = false;
                }
            }
            if (this.to == null) continue;
            comparison = notValue.compareTo(this.to);
            if (comparison >= 0) {
                notIt.remove();
            }
            if (comparison != 0) continue;
            this.toInclusive = false;
        }
    }

    private void detectImpossibleMatch() {
        int comparison;
        if (!(this.from == null || this.to == null || (comparison = this.from.compareTo(this.to)) <= 0 && (comparison != 0 || this.fromInclusive && this.toInclusive))) {
            this.impossibleMatch = true;
        }
    }

    @Override
    public NumericConditionDetector merge(NumericConditionDetector other) {
        return new NumericConditionDetector(this, other);
    }
}

