/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.explorer.navigation.qa.VerifyFactWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;

public class VerifyFactsPanel
extends VerticalPanel {
    private final Scenario scenario;
    private final ScenarioWidget parent;

    public VerifyFactsPanel(FixtureList verifyFacts, ExecutionTrace executionTrace, Scenario scenario, ScenarioWidget scenarioWidget, boolean showResults) {
        this.scenario = scenario;
        this.parent = scenarioWidget;
        SuggestionCompletionEngine suggestionCompletionEngine = scenarioWidget.suggestionCompletionEngine;
        for (Fixture fixture : verifyFacts) {
            if (!(fixture instanceof VerifyFact)) continue;
            VerifyFact verifyFact = (VerifyFact)fixture;
            HorizontalPanel column = new HorizontalPanel();
            column.add((Widget)new VerifyFactWidget(verifyFact, scenario, suggestionCompletionEngine, executionTrace, showResults));
            column.add((Widget)new DeleteButton(verifyFact));
            this.add((Widget)column);
        }
    }

    class DeleteButton
    extends ImageButton {
        public DeleteButton(final VerifyFact verifyFact) {
            super(DroolsGuvnorImages.INSTANCE.DeleteItemSmall(), Constants.INSTANCE.DeleteTheExpectationForThisFact());
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveThisExpectation())) {
                        VerifyFactsPanel.this.scenario.removeFixture((Fixture)verifyFact);
                        VerifyFactsPanel.this.parent.renderEditor();
                    }
                }
            });
        }
    }
}

