/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;

public class CellValue<T extends Comparable<T>>
implements Comparable<CellValue<T>> {
    private T value;
    private int rowSpan = 1;
    private Coordinate coordinate = new Coordinate();
    private Coordinate mapHtmlToData = new Coordinate();
    private Coordinate mapDataToHtml = new Coordinate();
    private EnumSet<CellState> state = EnumSet.noneOf(CellState.class);

    public CellValue(T value) {
        this.value = value;
    }

    public void addState(CellState state) {
        this.state.add(state);
    }

    @Override
    public int compareTo(CellValue<T> cv) {
        if (this.value == null) {
            if (cv.value == null) {
                return 0;
            }
            return 1;
        }
        if (cv.value == null) {
            return -1;
        }
        return this.value.compareTo(cv.value);
    }

    public GroupedCellValue convertToGroupedCell() {
        GroupedCellValue groupedCell = new GroupedCellValue(this, this.getValue());
        if (this.isOtherwise()) {
            groupedCell.addState(CellState.OTHERWISE);
        }
        return groupedCell;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValue)) {
            return false;
        }
        CellValue that = (CellValue)obj;
        return this.equalOrNull(this.value, that.value) && this.rowSpan == that.rowSpan && this.equalOrNull(this.coordinate, that.coordinate) && this.equalOrNull(this.mapHtmlToData, that.mapHtmlToData) && this.equalOrNull(this.mapDataToHtml, that.mapDataToHtml) && this.state.equals(that.state);
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate getHtmlCoordinate() {
        return new Coordinate(this.mapDataToHtml);
    }

    public Coordinate getPhysicalCoordinate() {
        return new Coordinate(this.mapHtmlToData);
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.value == null ? 0 : this.value.hashCode());
        hash = hash * 31 + this.rowSpan;
        hash = hash * 31 + (this.coordinate == null ? 0 : this.coordinate.hashCode());
        hash = hash * 31 + (this.mapHtmlToData == null ? 0 : this.mapHtmlToData.hashCode());
        hash = hash * 31 + (this.mapDataToHtml == null ? 0 : this.mapDataToHtml.hashCode());
        hash = hash * 31 + this.state.hashCode();
        return hash;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isGrouped() {
        return this.state.contains((Object)CellState.GROUPED);
    }

    public boolean isOtherwise() {
        return this.state.contains((Object)CellState.OTHERWISE);
    }

    public boolean isSelected() {
        return this.state.contains((Object)CellState.SELECTED);
    }

    public void removeState(CellState state) {
        this.state.remove((Object)state);
    }

    public void setCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.coordinate = coordinate;
    }

    public void setHtmlCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapDataToHtml = c;
    }

    public void setPhysicalCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapHtmlToData = c;
    }

    public void setRowSpan(int rowSpan) {
        if (rowSpan < 0) {
            throw new IllegalArgumentException("rowSpan cannot be less than zero.");
        }
        this.rowSpan = rowSpan;
    }

    public void setValue(Object value) {
        this.value = (Comparable)value;
    }

    private boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static class GroupedCellValue
    extends CellValue<T> {
        private List<CellValue<T>> groupedCells;
        final /* synthetic */ CellValue this$0;

        public GroupedCellValue(T value) {
            this.this$0 = var1_1;
            super(value);
            this.groupedCells = new ArrayList();
        }

        public void addCellToGroup(CellValue<T> cell) {
            this.groupedCells.add(cell);
        }

        @Override
        public void addState(CellState state) {
            for (CellValue cell : this.groupedCells) {
                cell.addState(state);
            }
            super.addState(state);
        }

        public boolean hasMultipleValues() {
            return this.checkForMultipleValues();
        }

        @Override
        public void removeState(CellState state) {
            for (CellValue cell : this.groupedCells) {
                cell.removeState(state);
            }
            super.removeState(state);
        }

        @Override
        public void setValue(Object value) {
            for (CellValue cell : this.groupedCells) {
                cell.setValue(value);
            }
            super.setValue(value);
        }

        private boolean checkForMultipleValues() {
            boolean hasMultipleValues = false;
            Object value1 = super.getValue();
            for (CellValue cell : this.groupedCells) {
                if (cell instanceof GroupedCellValue) {
                    GroupedCellValue gcv = (GroupedCellValue)cell;
                    hasMultipleValues = hasMultipleValues || gcv.checkForMultipleValues();
                }
                Object value2 = cell.getValue();
                hasMultipleValues = hasMultipleValues || !this.this$0.equalOrNull(value1, value2);
            }
            return hasMultipleValues;
        }

        List<CellValue<T>> getGroupedCells() {
            return this.groupedCells;
        }
    }

    public static enum CellState {
        SELECTED,
        GROUPED,
        OTHERWISE;

    }
}

