/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.workitems;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.guvnor.client.common.IBindingProvider;
import org.drools.guvnor.client.common.NumericIntegerTextBox;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.widgets.drools.workitems.WorkItemParameterWidget;
import org.drools.ide.common.shared.workitems.PortableIntegerParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;

public class WorkItemIntegerParameterWidget
extends WorkItemParameterWidget {
    @UiField
    Label parameterName;
    @UiField
    NumericIntegerTextBox parameterEditor;
    @UiField
    ListBox lstAvailableBindings;
    private static WorkItemIntegerParameterWidgetBinder uiBinder = (WorkItemIntegerParameterWidgetBinder)GWT.create(WorkItemIntegerParameterWidgetBinder.class);

    public WorkItemIntegerParameterWidget(PortableIntegerParameterDefinition ppd, IBindingProvider bindingProvider, boolean isReadOnly) {
        super((PortableParameterDefinition)ppd, bindingProvider);
        Set bindings;
        this.parameterName.setText(ppd.getName());
        this.parameterEditor.setEnabled(!isReadOnly);
        if (ppd.getValue() != null) {
            this.parameterEditor.setText(Integer.toString(ppd.getValue()));
        }
        if ((bindings = bindingProvider.getBindings(ppd.getClassName())).size() > 0) {
            this.lstAvailableBindings.clear();
            this.lstAvailableBindings.addItem(Constants.INSTANCE.Choose());
            this.lstAvailableBindings.setEnabled(!isReadOnly);
            this.lstAvailableBindings.setVisible(true);
            int selectedIndex = 0;
            for (String binding : bindings) {
                this.lstAvailableBindings.addItem(binding);
                if (!binding.equals(ppd.getBinding())) continue;
                selectedIndex = this.lstAvailableBindings.getItemCount() - 1;
            }
            this.lstAvailableBindings.setSelectedIndex(selectedIndex);
            this.parameterEditor.setEnabled(selectedIndex == 0 && !isReadOnly);
        }
    }

    @Override
    protected Widget getWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"parameterEditor"})
    void parameterEditorOnChange(ChangeEvent event) {
        try {
            ((PortableIntegerParameterDefinition)this.ppd).setValue(Integer.valueOf(Integer.parseInt(this.parameterEditor.getText())));
        }
        catch (NumberFormatException nfe) {
            ((PortableIntegerParameterDefinition)this.ppd).setValue(null);
        }
    }

    @UiHandler(value={"lstAvailableBindings"})
    void lstAvailableBindingsOnChange(ChangeEvent event) {
        int index = this.lstAvailableBindings.getSelectedIndex();
        this.parameterEditor.setEnabled(index == 0);
        if (index > 0) {
            ((PortableIntegerParameterDefinition)this.ppd).setValue(null);
            ((PortableIntegerParameterDefinition)this.ppd).setBinding(this.lstAvailableBindings.getItemText(index));
        } else {
            ((PortableIntegerParameterDefinition)this.ppd).setBinding("");
        }
    }

    static interface WorkItemIntegerParameterWidgetBinder
    extends UiBinder<HorizontalPanel, WorkItemIntegerParameterWidget> {
    }
}

