/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Collection;
import org.drools.definition.process.Node;
import org.drools.guvnor.client.asseteditor.ruleflow.ElementContainerTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.HumanTaskTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.TransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.WorkItemTransferNode;
import org.drools.process.core.Work;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.WorkItemNode;

public class RuleFlowProcessBuilder {
    public static void updateProcess(RuleFlowProcess process, Collection<TransferNode> contentNodes) {
        for (TransferNode transferNode : contentNodes) {
            Node node = process.getNode(transferNode.getId());
            RuleFlowProcessBuilder.updateNode(transferNode, node);
        }
    }

    private static void updateNode(TransferNode transferNode, Node node) {
        if (transferNode instanceof HumanTaskTransferNode) {
            RuleFlowProcessBuilder.updateHumanTask((HumanTaskTransferNode)transferNode, (HumanTaskNode)node);
        } else if (transferNode instanceof WorkItemTransferNode) {
            RuleFlowProcessBuilder.updateWorkItem((WorkItemTransferNode)transferNode, (WorkItemNode)node);
        } else if (transferNode instanceof SplitTransferNode) {
            RuleFlowProcessBuilder.updateSplitNode((SplitTransferNode)transferNode, (Split)node);
        } else if (transferNode instanceof ElementContainerTransferNode) {
            if (transferNode.getType() == TransferNode.Type.FOR_EACH) {
                RuleFlowProcessBuilder.updateForEach((ElementContainerTransferNode)transferNode, (ForEachNode)node);
            } else if (transferNode.getType() == TransferNode.Type.COMPOSITE) {
                RuleFlowProcessBuilder.updateComposite((ElementContainerTransferNode)transferNode, (CompositeNode)node);
            }
        }
    }

    private static void updateHumanTask(HumanTaskTransferNode transferNode, HumanTaskNode humanTaskNode) {
        Work work = humanTaskNode.getWork();
        if (work != null) {
            for (String key : work.getParameters().keySet()) {
                work.setParameter(key, transferNode.getParameters().get(key));
            }
        }
    }

    private static void updateWorkItem(WorkItemTransferNode transferNode, WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        if (work != null) {
            for (String key : work.getParameters().keySet()) {
                work.setParameter(key, transferNode.getParameters().get(key));
            }
        }
    }

    private static void updateSplitNode(SplitTransferNode splitTransferNode, Split splitNode) {
        for (ConnectionRef connection : splitNode.getConstraints().keySet()) {
            ConnectionRef connectionRef = new ConnectionRef(connection.getNodeId(), connection.getToType());
            SplitNode.ConnectionRef splitNodeConnectionRef = new SplitNode.ConnectionRef();
            splitNodeConnectionRef.setNodeId(connection.getNodeId());
            splitNodeConnectionRef.setToType(connection.getToType());
            Constraint constraint = splitNode.internalGetConstraint(connectionRef);
            SplitNode.Constraint splitNodeConstraint = (SplitNode.Constraint)splitTransferNode.getConstraints().get(splitNodeConnectionRef);
            RuleFlowProcessBuilder.updateConstraint(constraint, splitNodeConstraint);
        }
    }

    private static void updateForEach(ElementContainerTransferNode transferNode, ForEachNode foreachNode) {
        for (TransferNode subTransferNode : transferNode.getContentModel().getNodes()) {
            Node subNode = foreachNode.getNode(subTransferNode.getId());
            RuleFlowProcessBuilder.updateNode(subTransferNode, subNode);
        }
    }

    private static void updateComposite(ElementContainerTransferNode transferNode, CompositeNode compositeNode) {
        for (TransferNode subTransferNode : transferNode.getContentModel().getNodes()) {
            Node subNode = compositeNode.getNode(subTransferNode.getId());
            RuleFlowProcessBuilder.updateNode(subTransferNode, subNode);
        }
    }

    private static void updateConstraint(Constraint constraint, SplitNode.Constraint from) {
        constraint.setConstraint(from.getConstraint());
        constraint.setDialect(from.getDialect());
        constraint.setName(from.getName());
        constraint.setPriority(from.getPriority());
        constraint.setType(from.getType());
    }
}

