/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.PlainTextContentHandler;
import org.drools.repository.AssetItem;

public class DRLFileContentHandler
extends PlainTextContentHandler
implements IRuleAsset {
    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        String content = this.getRawDRL(asset);
        if (content != null && !content.trim().equals("")) {
            builder.addPackageFromDrl((Reader)new StringReader(content));
        }
    }

    String wrapRuleDeclaration(String name, String parentName, String content) {
        if (parentName == null || "".equals(parentName)) {
            return "rule '" + name + "'\n" + this.getContent(content) + "\nend";
        }
        return "rule '" + name + "' extends " + parentName + "\n" + this.getContent(content) + "\nend";
    }

    String getContent(String content) {
        if (content != null && !content.contains("dialect")) {
            return "dialect 'mvel'\n" + content;
        }
        return content;
    }

    public static boolean isStandAloneRule(String content) {
        if (content == null || "".equals(content.trim())) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(content, "\n\r");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.startsWith("when")) {
                return true;
            }
            if (!DRLFileContentHandler.startsWithWord("package", tok) && !DRLFileContentHandler.startsWithWord("rule", tok) && !DRLFileContentHandler.startsWithWord("end", tok) && !DRLFileContentHandler.startsWithWord("function", tok) && !DRLFileContentHandler.startsWithWord("query", tok)) continue;
            return false;
        }
        return true;
    }

    static boolean startsWithWord(String word, String sentence) {
        String[] words = sentence.trim().split("\\s");
        if (words.length > 0) {
            return words[0].equals(word);
        }
        return false;
    }

    public void assembleDRL(BRMSPackageBuilder builder, Asset asset, StringBuilder stringBuilder) {
        String content = ((RuleContentText)asset.getContent()).content;
        if (DRLFileContentHandler.isStandAloneRule(content)) {
            content = this.wrapRuleDeclaration(asset.getName(), "", content);
        }
        stringBuilder.append(content);
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuilder stringBuilder) {
        String content = this.getRawDRL(asset);
        stringBuilder.append(content);
    }

    public String getRawDRL(AssetItem asset) {
        String content = asset.getContent();
        if (DRLFileContentHandler.isStandAloneRule(content)) {
            String parentName = this.parentNameFromCategory(asset, "");
            content = this.wrapRuleDeclaration(asset.getName(), parentName, content);
        }
        return content;
    }
}

