/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.server.converters.decisiontable.builders.AbstractGuidedDecisionTableAttributeBuilder;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;

public class GuidedDecisionTableSalienceBuilder
extends AbstractGuidedDecisionTableAttributeBuilder {
    private final boolean isSequential;

    public GuidedDecisionTableSalienceBuilder(int row, int column, boolean isSequential, ConversionResult conversionResult) {
        super(row, column, ActionType.Code.SALIENCE, conversionResult);
        this.isSequential = isSequential;
    }

    @Override
    public void populateDecisionTable(GuidedDecisionTable52 dtable) {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("salience");
        if (this.isSequential) {
            column.setUseRowNumber(true);
            column.setReverseOrder(true);
            int maxRow = this.values.size();
            for (int iRow = 0; iRow < maxRow; ++iRow) {
                DTCellValue52 dcv = (DTCellValue52)this.values.get(iRow);
                dcv.setNumericValue(new Integer(maxRow - iRow));
            }
        }
        dtable.getAttributeCols().add(column);
        this.addColumnData(dtable, (DTColumnConfig52)column);
    }

    public void addCellValue(int row, int column, String value) {
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.lastIndexOf(")") - 1);
        }
        DTCellValue52 dcv = new DTCellValue52();
        try {
            dcv.setNumericValue(new Integer(value));
        }
        catch (NumberFormatException nfe) {
            String message = "Priority is not an integer literal, in cell " + RuleSheetParserUtil.rc2name((int)row, (int)column);
            this.conversionResult.addMessage(message, ConversionResult.ConversionMessageType.WARNING);
        }
        this.values.add(dcv);
    }
}

