/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.storage.ChannelDataInput;

public class ChannelImageInputStream
extends ChannelDataInput
implements ImageInputStream {
    public ChannelImageInputStream(String string, ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, boolean bl) throws IOException {
        super(string, readableByteChannel, byteBuffer, bl);
    }

    public ChannelImageInputStream(ChannelDataInput channelDataInput) throws IOException {
        super(channelDataInput.filename, channelDataInput.channel, channelDataInput.buffer, true);
    }

    @Override
    public final void setByteOrder(ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
    }

    @Override
    public final ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    @Override
    public final long length() throws IOException {
        if (this.channel instanceof FileChannel) {
            return ((FileChannel)this.channel).size();
        }
        return -1L;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String readUTF() throws IOException {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            String string = DataInputStream.readUTF(this);
            return string;
        }
        finally {
            this.buffer.order(byteOrder);
        }
    }

    @Override
    public final String readLine() throws IOException {
        int n = this.read();
        if (n < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        block4: while ((n = this.read()) >= 0) {
            switch (n) {
                case 13: {
                    n = this.read();
                    if (n < 0 || n == 10) break block4;
                    this.pushBack();
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    stringBuilder.append((char)n);
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public final int read() throws IOException {
        return this.hasRemaining() ? this.buffer.get() & 0xFF : -1;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.hasRemaining()) {
            return -1;
        }
        int n3 = n2;
        while (n2 != 0 && this.hasRemaining()) {
            int n4 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n4);
            n += n4;
            n2 -= n4;
        }
        return n3 - n2;
    }

    @Override
    public final void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        byte[] byArray = new byte[n];
        n = this.read(byArray);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        if (!this.hasRemaining()) {
            return 0;
        }
        int n2 = this.buffer.remaining();
        if (n >= n2) {
            n = n2;
        }
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    @Override
    public final long skipBytes(long l) throws IOException {
        return this.skipBytes(Math.min((int)l, Integer.MAX_VALUE));
    }

    @Override
    public final void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public final boolean isCached() {
        return this.isCachedMemory();
    }

    @Override
    public final boolean isCachedMemory() {
        return false;
    }

    @Override
    public final boolean isCachedFile() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }
}

