/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.GeoBoundingBox;
import org.apache.lucene.search.GeoPointDistanceQuery;
import org.apache.lucene.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.search.GeoPointTermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.GeoUtils;
import org.apache.lucene.util.SloppyMath;

final class GeoPointDistanceQueryImpl
extends GeoPointInBBoxQueryImpl {
    private final GeoPointDistanceQuery query;

    GeoPointDistanceQueryImpl(String field, GeoPointDistanceQuery q, GeoBoundingBox bbox) {
        super(field, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        this.query = q;
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new GeoPointRadiusTermsEnum(terms.iterator(), this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQueryImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQueryImpl that = (GeoPointDistanceQueryImpl)((Object)o);
        return this.query.equals((Object)that.query);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.query.hashCode();
        return result;
    }

    private final class GeoPointRadiusTermsEnum
    extends GeoPointTermsEnum {
        GeoPointRadiusTermsEnum(TermsEnum tenum, double minLon, double minLat, double maxLon, double maxLat) {
            super(tenum, minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectCrossesCircle(minLon, minLat, maxLon, maxLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.radius);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectWithinCircle(minLon, minLat, maxLon, maxLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.radius);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellContains(minLon, minLat, maxLon, maxLat) || this.cellWithin(minLon, minLat, maxLon, maxLat) || this.cellCrosses(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return SloppyMath.haversin((double)((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLat, (double)((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.centerLon, (double)lat, (double)lon) * 1000.0 <= ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).query.radius;
        }
    }
}

