/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.interpreter;

import org.apache.deltaspike.core.api.interpreter.ExpressionInterpreter;
import org.apache.deltaspike.core.api.interpreter.SimpleOperationEnum;

public abstract class BasePropertyExpressionInterpreter
implements ExpressionInterpreter<String, Boolean> {
    private static final String ASTERISK = "*";

    @Override
    public final Boolean evaluate(String expressions) {
        String[] foundExpressions;
        boolean result = false;
        for (String expression : foundExpressions = expressions.split(";")) {
            SimpleOperationEnum operation;
            result = false;
            if (expression.contains(SimpleOperationEnum.IS.getValue())) {
                operation = SimpleOperationEnum.IS;
            } else if (expression.contains(SimpleOperationEnum.NOT.getValue())) {
                operation = SimpleOperationEnum.NOT;
            } else {
                throw new IllegalStateException("expression: " + expression + " isn't supported by " + this.getClass().getName() + " supported operations: " + SimpleOperationEnum.getOperations() + "separator: ';'");
            }
            String[] keyValue = expression.split(operation.getValue());
            String configuredValue = this.getConfiguredValue(keyValue[0]);
            configuredValue = configuredValue != null ? configuredValue.trim() : "";
            if (!ASTERISK.equals(keyValue[1]) && "".equals(configuredValue)) continue;
            if (ASTERISK.equals(keyValue[1]) && !"".equals(configuredValue)) {
                result = true;
                continue;
            }
            if (SimpleOperationEnum.IS.equals((Object)operation) && !keyValue[1].equalsIgnoreCase(configuredValue)) {
                return false;
            }
            if (SimpleOperationEnum.NOT.equals((Object)operation) && keyValue[1].equalsIgnoreCase(configuredValue)) {
                return false;
            }
            result = true;
        }
        return result;
    }

    protected abstract String getConfiguredValue(String var1);
}

