/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.handler;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.kie.workbench.common.screens.datamodeller.backend.server.handler.DomainHandler;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.driver.impl.JavaRoasterModelDriver;

@ApplicationScoped
public class JPADomainHandler
implements DomainHandler {
    @Override
    public void setDefaultValues(DataObject dataObject, Map<String, Object> portableParams) {
        if (portableParams != null) {
            String tableName;
            Object currentValue = portableParams.get("persistable");
            boolean isPersistable = Boolean.valueOf(currentValue != null ? currentValue.toString() : null);
            currentValue = portableParams.get("tableName");
            String string = tableName = currentValue != null ? currentValue.toString() : null;
            if (isPersistable) {
                boolean isAuditable;
                JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
                dataObject.addAnnotation((Annotation)new AnnotationImpl(modelDriver.getConfiguredAnnotation(Entity.class.getName())));
                if (tableName != null && !"".equals(tableName.trim())) {
                    AnnotationImpl tableAnnotation = new AnnotationImpl(modelDriver.getConfiguredAnnotation(Table.class.getName()));
                    tableAnnotation.setValue("name", (Object)tableName.trim());
                    dataObject.addAnnotation((Annotation)tableAnnotation);
                }
                ObjectProperty id = dataObject.addProperty("id", Long.class.getName());
                id.addAnnotation((Annotation)new AnnotationImpl(modelDriver.getConfiguredAnnotation(Id.class.getName())));
                String generatorName = this.createDefaultGeneratorName(dataObject.getName());
                AnnotationImpl generatedValue = new AnnotationImpl(modelDriver.getConfiguredAnnotation(GeneratedValue.class.getName()));
                generatedValue.setValue("generator", (Object)generatorName);
                generatedValue.setValue("strategy", (Object)GenerationType.AUTO.name());
                id.addAnnotation((Annotation)generatedValue);
                AnnotationImpl sequenceGenerator = new AnnotationImpl(modelDriver.getConfiguredAnnotation(SequenceGenerator.class.getName()));
                String sequenceName = this.createDefaultSequenceName(dataObject.getName());
                sequenceGenerator.setValue("name", (Object)generatorName);
                sequenceGenerator.setValue("sequenceName", (Object)sequenceName);
                id.addAnnotation((Annotation)sequenceGenerator);
                boolean bl = isAuditable = portableParams.containsKey("audited") ? Boolean.valueOf(portableParams.get("audited").toString()) : false;
                if (isAuditable) {
                    AnnotationImpl audited = new AnnotationImpl(modelDriver.getConfiguredAnnotation(Audited.class.getName()));
                    audited.setValue("targetAuditMode", (Object)RelationTargetAuditMode.NOT_AUDITED.name());
                    dataObject.addAnnotation((Annotation)audited);
                }
            }
        }
    }

    @Override
    public List<AnnotationDefinition> getManagedAnnotations() {
        return null;
    }

    private String createDefaultGeneratorName(String objectName) {
        return objectName.toUpperCase() + "_ID_GENERATOR";
    }

    private String createDefaultSequenceName(String objectName) {
        return objectName.toUpperCase() + "_ID_SEQ";
    }
}

