/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.validation;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.backend.server.validation.PersistenceDescriptorValidationMessages;

public class PersistableClassValidator {
    public List<ValidationMessage> validate(String className, ClassLoader classLoader) {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        try {
            if (className == null || className.trim().isEmpty()) {
                result.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTABLE_CLASS_NAME_EMPTY_ID, "Empty persistable class name was found", new String[0]));
                return result;
            }
            Class<?> clazz = classLoader.loadClass(className);
            Annotation[] annotations = clazz.getAnnotations();
            Optional<Annotation> persistable = Arrays.stream(annotations).filter(annotation -> Entity.class.equals(annotation.annotationType()) || Embeddable.class.equals(annotation.annotationType()) || MappedSuperclass.class.equals(annotation.annotationType())).findFirst();
            if (!persistable.isPresent()) {
                result.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.CLASS_NOT_PERSISTABLE_ID, MessageFormat.format("Class \"{0}\" must be a persistable class", className), className));
            }
        }
        catch (ClassNotFoundException e) {
            result.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.CLASS_NOT_FOUND_ID, MessageFormat.format("Class \"{0}\" was not found in current project class path", className), className));
        }
        return result;
    }
}

