/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.catalog.InvDocumentation;
import thredds.catalog.query.DqcConvertIF;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.ListChoice;
import thredds.catalog.query.Location;
import thredds.catalog.query.Query;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectGeoRegion;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectRange;
import thredds.catalog.query.SelectRangeDate;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;

public class DqcConvert4
implements DqcConvertIF {
    public static boolean debugURL = false;
    public static boolean debugXML = false;
    public static boolean debugDBurl = false;
    public static boolean debugXMLopen = false;
    public static boolean showParsedXML = false;
    public static boolean showXMLoutput = false;
    protected static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private DqcFactory factory;
    private URI docURI;

    @Override
    public QueryCapability parseXML(DqcFactory fac, Document jdomDoc, URI uri) throws IOException {
        this.factory = fac;
        this.docURI = uri;
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** DqcConvert3/showParsedXML = \n" + xmlOut.outputString(jdomDoc) + "\n*******");
        }
        QueryCapability qc = this.readQC(jdomDoc.getRootElement());
        if (showXMLoutput) {
            System.out.println("*** DqcConvert3/showXMLoutput");
            this.writeXML(qc, System.out);
        }
        return qc;
    }

    private ListChoice readChoice(QueryCapability qc, Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        ListChoice c = new ListChoice(parent, name, value, null);
        List children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            Element child = (Element)children.get(j);
            String childName = child.getName();
            if (!childName.equals("selectList")) continue;
            c.addNestedSelector(this.readSelectList(qc, child));
        }
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            c.setDescription(this.readDocumentation(descElem));
        }
        return c;
    }

    private Element writeChoice(ListChoice c) {
        Element elem = new Element("choice", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        if (c.getDescription() != null) {
            elem.addContent((Content)this.writeDocumentation(c.getDescription(), "description"));
        }
        ArrayList selectors = c.getNestedSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s = (Selector)selectors.get(i);
            if (!(s instanceof SelectList)) continue;
            elem.addContent((Content)this.writeSelectList((SelectList)s));
        }
        return elem;
    }

    protected InvDocumentation readDocumentation(Element s) {
        String href = s.getAttributeValue("href", xlinkNS);
        String title = s.getAttributeValue("title", xlinkNS);
        String type = s.getAttributeValue("type");
        String content = s.getTextNormalize();
        URI uriResolved = null;
        if (href != null) {
            try {
                uriResolved = this.docURI.resolve(href);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid documentation href = " + href + " " + e.getMessage() + "\n");
            }
        }
        return new InvDocumentation(href, uriResolved, title, type, content);
    }

    private Element writeDocumentation(InvDocumentation doc, String name) {
        String inline;
        Element docElem = new Element(name, defNS);
        if (doc.getType() != null) {
            docElem.setAttribute("type", doc.getType());
        }
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getURI().toString(), xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    private Location readLocation(Element locationElem) {
        if (locationElem == null) {
            return null;
        }
        String latitude = locationElem.getAttributeValue("latitude");
        String longitude = locationElem.getAttributeValue("longitude");
        String elevation = locationElem.getAttributeValue("elevation");
        String latitude_units = locationElem.getAttributeValue("latitude_units");
        String longitude_units = locationElem.getAttributeValue("longitude_units");
        String elevation_units = locationElem.getAttributeValue("elevation_units");
        Location location = new Location(latitude, longitude, elevation, latitude_units, longitude_units, elevation_units);
        return location;
    }

    private Element writeLocation(Location l, String elemName) {
        Element locationElem = new Element(l.hasElevation() ? "location3D" : elemName, defNS);
        locationElem.setAttribute("latitude", Double.toString(l.getLatitude()));
        locationElem.setAttribute("longitude", Double.toString(l.getLongitude()));
        if (!l.isDefaultLatitudeUnits()) {
            locationElem.setAttribute("latitude_units", l.getLatitudeUnits());
        }
        if (!l.isDefaultLongitudeUnits()) {
            locationElem.setAttribute("longitude_units", l.getLongitudeUnits());
        }
        if (l.hasElevation()) {
            locationElem.setAttribute("elevation", Double.toString(l.getElevation()));
            if (!l.isDefaultElevationUnits()) {
                locationElem.setAttribute("elevation_units", l.getElevationUnits());
            }
        }
        return locationElem;
    }

    private QueryCapability readQC(Element qcElem) {
        int j;
        String name = qcElem.getAttributeValue("name");
        String version = qcElem.getAttributeValue("version");
        QueryCapability qc = new QueryCapability(this.docURI.toString(), name, version);
        qc.setQuery(this.readQuery(qcElem.getChild("query", defNS)));
        SelectService s = this.readSelectService(qcElem.getChild("selectService", defNS));
        if (null != s) {
            qc.addUniqueSelector(s);
            qc.setServiceSelector(s);
        }
        List list = qcElem.getChildren("userInterface", defNS);
        for (j = 0; j < list.size(); ++j) {
            Element child = (Element)list.get(j);
            qc.addUserInterface(child);
        }
        this.readSelectors(qc, qcElem);
        list = qcElem.getChildren("compound", defNS);
        for (j = 0; j < list.size(); ++j) {
            Element compoundElem = (Element)list.get(j);
            List compound = this.readSelectors(qc, compoundElem);
            for (Selector sel : compound) {
                sel.setCompoundSelectors(compound);
            }
        }
        return qc;
    }

    private List readSelectors(QueryCapability qc, Element elem) {
        Selector s;
        int j;
        ArrayList<SelectList> compound = new ArrayList<SelectList>();
        List list = elem.getChildren("selectList", defNS);
        for (j = 0; j < list.size(); ++j) {
            s = this.readSelectList(qc, (Element)list.get(j));
            if (null == s) continue;
            qc.addUniqueSelector(s);
            compound.add((SelectList)s);
        }
        list = elem.getChildren("selectStation", defNS);
        for (j = 0; j < list.size(); ++j) {
            s = this.readSelectStation((Element)list.get(j));
            if (null == s) continue;
            qc.addUniqueSelector(s);
            compound.add((SelectList)s);
        }
        list = elem.getChildren("selectFromRange", defNS);
        for (j = 0; j < list.size(); ++j) {
            s = this.readSelectRange((Element)list.get(j));
            if (null == s) continue;
            qc.addUniqueSelector(s);
            compound.add((SelectList)s);
        }
        list = elem.getChildren("selectFromDateRange", defNS);
        for (j = 0; j < list.size(); ++j) {
            s = this.readSelectRangeDate((Element)list.get(j));
            if (null == s) continue;
            qc.addUniqueSelector(s);
            compound.add((SelectList)s);
        }
        list = elem.getChildren("selectFromGeoRegion", defNS);
        for (j = 0; j < list.size(); ++j) {
            s = this.readSelectGeoRegion((Element)list.get(j));
            if (null == s) continue;
            qc.addUniqueSelector(s);
            compound.add((SelectList)s);
        }
        return compound;
    }

    public Document writeQC(QueryCapability qc) {
        Element rootElem = new Element("queryCapability", defNS);
        Document doc = new Document(rootElem);
        if (null != qc.getName()) {
            rootElem.setAttribute("name", qc.getName());
        }
        rootElem.setAttribute("version", qc.getVersion());
        rootElem.addContent((Content)this.writeQuery(qc.getQuery()));
        Selector s = qc.getServiceSelector();
        Element elem = this.writeSelectService((SelectService)s);
        if (elem != null) {
            rootElem.addContent((Content)elem);
        }
        ArrayList selectors = qc.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            s = (Selector)selectors.get(i);
            if (s instanceof SelectList) {
                rootElem.addContent((Content)this.writeSelectList((SelectList)s));
                continue;
            }
            if (s instanceof SelectRange) {
                rootElem.addContent((Content)this.writeSelectRange((SelectRange)s));
                continue;
            }
            if (s instanceof SelectRangeDate) {
                rootElem.addContent((Content)this.writeSelectRangeDate((SelectRangeDate)s));
                continue;
            }
            if (s instanceof SelectGeoRegion) {
                rootElem.addContent((Content)this.writeSelectGeoRegion((SelectGeoRegion)s));
                continue;
            }
            if (s instanceof SelectService || !(s instanceof SelectStation)) continue;
            rootElem.addContent((Content)this.writeSelectStation((SelectStation)s));
        }
        return doc;
    }

    private Query readQuery(Element s) {
        String base = s.getAttributeValue("base");
        URI uriResolved = null;
        if (base != null) {
            try {
                uriResolved = this.docURI.resolve(base);
            }
            catch (Exception e) {
                this.factory.appendFatalErr(" ** Invalid query base = " + base + " " + e.getMessage() + "\n");
            }
        }
        return new Query(base, uriResolved, null);
    }

    private Element writeQuery(Query q) {
        Element elem = new Element("query", defNS);
        elem.setAttribute("base", q.getBase());
        return elem;
    }

    private void readSelector(Element elem, Selector s) {
        s.setTitle(elem.getAttributeValue("title"));
        s.setId(elem.getAttributeValue("id"));
        s.setTemplate(elem.getAttributeValue("template"));
        s.setRequired(elem.getAttributeValue("required"));
        s.setMultiple(elem.getAttributeValue("multiple"));
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            s.setDescription(this.readDocumentation(descElem));
        }
    }

    private void writeSelector(Element elem, Selector s) {
        if (s.getId() != null) {
            elem.setAttribute("id", s.getId());
        }
        if (s.getTitle() != null) {
            elem.setAttribute("title", s.getTitle());
        }
        if (s.getTemplate() != null) {
            elem.setAttribute("template", s.getTemplate());
        }
        if (!s.isRequired()) {
            elem.setAttribute("required", "false");
        }
        if (s.isMultiple()) {
            elem.setAttribute("multiple", "true");
        }
        if (s.getDescription() != null) {
            elem.addContent((Content)this.writeDocumentation(s.getDescription(), "description"));
        }
    }

    private SelectList readSelectList(QueryCapability qc, Element elem) {
        SelectList slist = new SelectList();
        this.readSelector(elem, slist);
        List choices = elem.getChildren("choice", defNS);
        for (int j = 0; j < choices.size(); ++j) {
            ListChoice choice = this.readChoice(qc, slist, (Element)choices.get(j));
            slist.addChoice(choice);
        }
        return slist;
    }

    private Element writeSelectList(SelectList s) {
        Element elem = new Element("selectList", defNS);
        this.writeSelector(elem, s);
        ArrayList choices = s.getChoices();
        for (int i = 0; i < choices.size(); ++i) {
            elem.addContent((Content)this.writeChoice((ListChoice)choices.get(i)));
        }
        return elem;
    }

    private SelectRange readSelectRange(Element elem) {
        String min = elem.getAttributeValue("min");
        String max = elem.getAttributeValue("max");
        String units = elem.getAttributeValue("units");
        String modulo = elem.getAttributeValue("modulo");
        String resolution = elem.getAttributeValue("resolution");
        String selectType = elem.getAttributeValue("selectType");
        SelectRange sr = new SelectRange(min, max, units, modulo, resolution, selectType);
        this.readSelector(elem, sr);
        return sr;
    }

    private Element writeSelectRange(SelectRange s) {
        Element elem = new Element("selectFromRange", defNS);
        this.writeSelector(elem, s);
        if (s.getMin() != null) {
            elem.setAttribute("min", s.getMin());
        }
        if (s.getMax() != null) {
            elem.setAttribute("max", s.getMax());
        }
        if (s.getUnits() != null) {
            elem.setAttribute("units", s.getUnits());
        }
        if (s.isModulo()) {
            elem.setAttribute("modulo", "true");
        }
        if (s.getResolution() != null) {
            elem.setAttribute("resolution", s.getResolution());
        }
        if (s.getSelectType() != null) {
            elem.setAttribute("selectType", s.getSelectType());
        }
        return elem;
    }

    private SelectRangeDate readSelectRangeDate(Element elem) {
        String start = elem.getAttributeValue("start");
        String end = elem.getAttributeValue("end");
        String duration = elem.getAttributeValue("duration");
        String resolution = elem.getAttributeValue("resolution");
        String selectType = elem.getAttributeValue("selectType");
        SelectRangeDate srd = new SelectRangeDate(start, end, duration, resolution, selectType);
        this.readSelector(elem, srd);
        return srd;
    }

    private Element writeSelectRangeDate(SelectRangeDate s) {
        Element elem = new Element("selectFromDateRange", defNS);
        this.writeSelector(elem, s);
        if (s.getStart() != null) {
            elem.setAttribute("start", s.getStart());
        }
        if (s.getEnd() != null) {
            elem.setAttribute("end", s.getEnd());
        }
        if (s.getDuration() != null) {
            elem.setAttribute("duration", s.getDuration());
        }
        if (s.getResolution() != null) {
            elem.setAttribute("resolution", s.getResolution());
        }
        if (s.getSelectType() != null) {
            elem.setAttribute("selectType", s.getSelectType());
        }
        return elem;
    }

    private SelectGeoRegion readSelectGeoRegion(Element elem) {
        Element geoBB = elem.getChild("geoBoundingBox", defNS);
        if (geoBB == null) {
            this.factory.appendErr("No geoBoundingBox in selectFromGeoRegion");
            return null;
        }
        Location lowerLeft = this.readLocation(geoBB.getChild("lowerLeft", defNS));
        Location upperRight = this.readLocation(geoBB.getChild("upperRight", defNS));
        SelectGeoRegion sr = new SelectGeoRegion(lowerLeft, upperRight);
        this.readSelector(elem, sr);
        return sr;
    }

    private Element writeSelectGeoRegion(SelectGeoRegion s) {
        Element elem = new Element("selectFromGeoRegion", defNS);
        this.writeSelector(elem, s);
        Element geoBB = new Element("geoBoundingBox", defNS);
        elem.addContent((Content)geoBB);
        if (s.getLowerLeft() != null) {
            geoBB.addContent((Content)this.writeLocation(s.getLowerLeft(), "lowerLeft"));
        }
        if (s.getUpperRight() != null) {
            geoBB.addContent((Content)this.writeLocation(s.getUpperRight(), "upperRight"));
        }
        return elem;
    }

    private SelectService readSelectService(Element elem) {
        if (elem == null) {
            return null;
        }
        SelectService ss = new SelectService(null, null);
        this.readSelector(elem, ss);
        List choices = elem.getChildren("serviceType", defNS);
        for (int j = 0; j < choices.size(); ++j) {
            Element choice = (Element)choices.get(j);
            String name = choice.getText();
            String title = choice.getAttributeValue("title");
            String dataFormatType = choice.getAttributeValue("dataFormatType");
            String returns = choice.getAttributeValue("returns");
            String value = choice.getAttributeValue("value");
            ss.addServiceChoice(name, title, dataFormatType, returns, value);
        }
        return ss;
    }

    private Element writeSelectService(SelectService ss) {
        if (ss == null) {
            return null;
        }
        Element elem = new Element("selectService", defNS);
        this.writeSelector(elem, ss);
        ArrayList choices = ss.getChoices();
        for (int i = 0; i < choices.size(); ++i) {
            SelectService.ServiceChoice s = (SelectService.ServiceChoice)choices.get(i);
            Element selem = new Element("serviceType", defNS);
            if (s.getTitle() != null) {
                selem.setAttribute("title", s.getTitle());
            }
            if (s.getDataFormat() != null) {
                selem.setAttribute("dataFormatType", s.getDataFormat());
            }
            if (s.getReturns() != null) {
                selem.setAttribute("returns", s.getReturns());
            }
            if (s.getValue2() != null) {
                selem.setAttribute("value", s.getValue2());
            }
            selem.addContent(s.getService());
            elem.addContent((Content)selem);
        }
        return elem;
    }

    private SelectStation readSelectStation(Element elem) {
        SelectStation ss = new SelectStation();
        this.readSelector(elem, ss);
        List stations = elem.getChildren("station", defNS);
        for (int j = 0; j < stations.size(); ++j) {
            Station station = this.readStation(ss, (Element)stations.get(j));
            ss.addStation(station);
        }
        return ss;
    }

    private Element writeSelectStation(SelectStation s) {
        Element elem = new Element("selectStation", defNS);
        this.writeSelector(elem, s);
        ArrayList stations = s.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            elem.addContent((Content)this.writeStation((Station)stations.get(i)));
        }
        return elem;
    }

    private Station readStation(Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        Station station = new Station(parent, name, value, null);
        Element locationElem = elem.getChild("location", defNS);
        if (null == locationElem) {
            locationElem = elem.getChild("location3D", defNS);
        }
        station.setLocation(this.readLocation(locationElem));
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            station.setDescription(this.readDocumentation(descElem));
        }
        return station;
    }

    private Element writeStation(Station c) {
        Element elem = new Element("station", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        if (c.getDescription() != null) {
            elem.addContent((Content)this.writeDocumentation(c.getDescription(), "description"));
        }
        elem.addContent((Content)this.writeLocation(c.getLocation(), "location"));
        return elem;
    }

    @Override
    public void writeXML(QueryCapability qc, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.writeQC(qc), os);
    }
}

