/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.ext.metadata.search.DateRange;
import org.uberfire.ext.metadata.search.IOSearchService;
import org.uberfire.ext.metadata.search.SearchIndex;

public class LuceneSearchIndex
implements SearchIndex {
    private final LuceneIndexManager indexManager;
    private final QueryParser queryParser;

    public LuceneSearchIndex(LuceneIndexManager indexManager, Analyzer analyzer) {
        this.indexManager = (LuceneIndexManager)PortablePreconditions.checkNotNull((String)"lucene", (Object)indexManager);
        this.queryParser = new QueryParser("fullText", analyzer);
        this.queryParser.setAllowLeadingWildcard(true);
    }

    public List<KObject> searchByAttrs(Map<String, ?> attrs, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return Collections.emptyList();
        }
        if (attrs == null || attrs.size() == 0) {
            return Collections.emptyList();
        }
        int totalNumHitsEstimate = this.searchByAttrsHits(attrs, clusterSegments);
        return this.search(this.buildQuery(attrs, clusterSegments), totalNumHitsEstimate, filter, clusterSegments);
    }

    public List<KObject> fullTextSearch(String term, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return Collections.emptyList();
        }
        int totalNumHitsEstimate = this.fullTextSearchHits(term, clusterSegments);
        return this.search(this.buildQuery(term, clusterSegments), totalNumHitsEstimate, filter, clusterSegments);
    }

    public int searchByAttrsHits(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return 0;
        }
        if (attrs == null || attrs.size() == 0) {
            return 0;
        }
        return this.searchHits(this.buildQuery(attrs, clusterSegments), clusterSegments);
    }

    public int fullTextSearchHits(String term, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return 0;
        }
        return this.searchHits(this.buildQuery(term, clusterSegments), clusterSegments);
    }

    private int searchHits(Query query, ClusterSegment ... clusterSegments) {
        IndexSearcher index = this.indexManager.getIndexSearcher(clusterSegments);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            index.search(query, (Collector)collector);
            int n = collector.getTotalHits();
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            this.indexManager.release(index);
        }
    }

    private List<KObject> search(Query query, int totalNumHitsEstimate, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)totalNumHitsEstimate);
        IndexSearcher index = this.indexManager.getIndexSearcher(clusterSegments);
        ArrayList<KObject> result = new ArrayList<KObject>();
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs((int)0).scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                KObject kObject = KObjectUtil.toKObject(index.doc(hits[i].doc));
                if (!filter.accept(kObject)) continue;
                result.add(kObject);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            this.indexManager.release(index);
        }
        return result;
    }

    private Query buildQuery(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        BooleanQuery query = new BooleanQuery();
        for (Map.Entry<String, ?> entry : attrs.entrySet()) {
            if (entry.getValue() instanceof DateRange) {
                Long from = ((DateRange)entry.getValue()).after().getTime();
                Long to = ((DateRange)entry.getValue()).before().getTime();
                query.add((Query)NumericRangeQuery.newLongRange((String)entry.getKey(), (Long)from, (Long)to, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
                continue;
            }
            if (entry.getValue() instanceof String) {
                query.add((Query)new WildcardQuery(new Term(entry.getKey(), entry.getValue().toString())), BooleanClause.Occur.MUST);
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            query.add((Query)new TermQuery(new Term(entry.getKey(), (Boolean)entry.getValue() != false ? "0" : "1")), BooleanClause.Occur.MUST);
        }
        return this.composeQuery((Query)query, clusterSegments);
    }

    private Query buildQuery(String term, ClusterSegment ... clusterSegments) {
        Query fullText;
        try {
            fullText = this.queryParser.parse(term);
            if (fullText.toString().isEmpty()) {
                fullText = new WildcardQuery(new Term("fullText", this.format(term) + "*"));
            }
        }
        catch (ParseException ex) {
            fullText = new WildcardQuery(new Term("fullText", this.format(term)));
        }
        return this.composeQuery(fullText, clusterSegments);
    }

    private Query composeQuery(Query query, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return query;
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        BooleanClause.Occur occur = clusterSegments.length == 1 ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        for (ClusterSegment clusterSegment : clusterSegments) {
            BooleanQuery clusterSegmentQuery = new BooleanQuery();
            this.addClusterIdTerms(clusterSegmentQuery, clusterSegment);
            this.addSegmentIdTerms(clusterSegmentQuery, clusterSegment);
            booleanQuery.add((Query)clusterSegmentQuery, occur);
        }
        return booleanQuery;
    }

    private void addClusterIdTerms(BooleanQuery query, ClusterSegment clusterSegment) {
        if (clusterSegment.getClusterId() != null) {
            TermQuery cluster = new TermQuery(new Term("cluster.id", clusterSegment.getClusterId()));
            query.add((Query)cluster, BooleanClause.Occur.MUST);
        }
    }

    private void addSegmentIdTerms(BooleanQuery query, ClusterSegment clusterSegment) {
        if (clusterSegment.segmentIds() == null || clusterSegment.segmentIds().length == 0) {
            return;
        }
        if (clusterSegment.segmentIds().length == 1) {
            TermQuery segment = new TermQuery(new Term("segment.id", clusterSegment.segmentIds()[0]));
            query.add((Query)segment, BooleanClause.Occur.MUST);
        } else {
            BooleanQuery segments = new BooleanQuery();
            for (String segmentId : clusterSegment.segmentIds()) {
                TermQuery segment = new TermQuery(new Term("segment.id", segmentId));
                segments.add((Query)segment, BooleanClause.Occur.SHOULD);
            }
            query.add((Query)segments, BooleanClause.Occur.MUST);
        }
    }

    private String format(String term) {
        return term.toLowerCase();
    }
}

