/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;

public class COSFloat
extends COSNumber {
    private BigDecimal value;
    private String valueAsString;

    public COSFloat(float aFloat) {
        this.setValue(aFloat);
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.valueAsString = aFloat;
            this.value = new BigDecimal(this.valueAsString);
            this.checkMinMaxValues();
        }
        catch (NumberFormatException e) {
            if (aFloat.startsWith("0.00000-")) {
                try {
                    this.valueAsString = "-0.00000" + aFloat.substring(8);
                    this.value = new BigDecimal(this.valueAsString);
                    this.checkMinMaxValues();
                }
                catch (NumberFormatException e2) {
                    throw new IOException("Error expected floating point number actual='" + aFloat + "'");
                }
            }
            throw new IOException("Error expected floating point number actual='" + aFloat + "'");
        }
    }

    public void setValue(float floatValue) {
        this.value = new BigDecimal(String.valueOf(floatValue));
        this.valueAsString = this.removeNullDigits(this.value.toPlainString());
    }

    private void checkMinMaxValues() {
        float floatValue = this.value.floatValue();
        double doubleValue = this.value.doubleValue();
        boolean valueReplaced = false;
        if (floatValue == Float.NEGATIVE_INFINITY || floatValue == Float.POSITIVE_INFINITY) {
            if (Math.abs(doubleValue) > 3.4028234663852886E38) {
                floatValue = Float.MAX_VALUE * (float)(floatValue == Float.POSITIVE_INFINITY ? 1 : -1);
                valueReplaced = true;
            }
        } else if (floatValue == 0.0f && doubleValue != 0.0 && Math.abs(doubleValue) < (double)1.4E-45f) {
            floatValue = Float.MIN_VALUE;
            floatValue *= doubleValue >= 0.0 ? 1.0f : -1.0f;
            valueReplaced = true;
        }
        if (valueReplaced) {
            this.value = new BigDecimal(floatValue);
            this.valueAsString = this.removeNullDigits(this.value.toPlainString());
        }
    }

    private String removeNullDigits(String value) {
        if (value.indexOf(".") > -1 && !value.endsWith(".0")) {
            while (value.endsWith("0") && !value.endsWith(".0")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value.floatValue()) == Float.floatToIntBits(this.value.floatValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "COSFloat{" + this.valueAsString + "}";
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromFloat(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(this.valueAsString.getBytes("ISO-8859-1"));
    }
}

