/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.workbench.jcr2vfsmigration.xml.format.ModuleXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.Modules;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModulesXmlFormat
implements XmlFormat<Modules> {
    public static final String MODULES = "modules";
    private ModuleXmlFormat moduleXmlFormat = new ModuleXmlFormat();

    @Override
    public void format(StringBuilder sb, Modules modules) {
        if (sb == null || modules == null) {
            throw new IllegalArgumentException("No output or Modules specified");
        }
        sb.append("<").append(MODULES).append(">");
        this.moduleXmlFormat.format(sb, modules.getGlobalModule());
        Iterator<Module> it = modules.getModules().iterator();
        while (it.hasNext()) {
            this.moduleXmlFormat.format(sb, it.next());
        }
        sb.append("</").append(MODULES).append(">");
    }

    @Override
    public Modules parse(Node modulesNode) {
        if (modulesNode == null || !MODULES.equals(modulesNode.getNodeName())) {
            throw new IllegalArgumentException("No input modules node specified for parsing");
        }
        Module global = null;
        ArrayList<Module> normal = new ArrayList<Module>(5);
        NodeList moduleNodes = modulesNode.getChildNodes();
        block3: for (int i = 0; i < moduleNodes.getLength(); ++i) {
            Node moduleNode = moduleNodes.item(i);
            if (moduleNode == null) continue;
            Module module = this.moduleXmlFormat.parse(moduleNode);
            switch (module.getType()) {
                case GLOBAL: {
                    global = module;
                    continue block3;
                }
                default: {
                    normal.add(module);
                }
            }
        }
        return new Modules(global, normal);
    }
}

