/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Parameter;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.kie.workbench.common.services.datamodeller.util.FileHashingUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationTools {
    public static final String EOL = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(GenerationTools.class);
    private static final String TAB = "    ";
    private static final String START_INDENT = "\n\n";
    private static final String ANNOTATION_START_INDENT = "\n";
    private static final String LINE_INDENT = "    ";
    private static final String END_INDENT = "\n";
    public static final int MAX_FIELDS_FOR_DEFAULT_CONSTRUCTOR = 120;

    public String fitToSize(int size, String name, char padChar) {
        int n = size - name.length();
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        for (int i = 0; i < n; ++i) {
            buf.append(padChar);
        }
        return buf.toString();
    }

    public String toJavaGetter(String name, String className) {
        String prefix = "boolean".equals(className != null ? className.trim() : null) ? "is" : "get";
        return this.toJavaAccessor(prefix, name);
    }

    public String toJavaSetter(String name) {
        return this.toJavaAccessor("set", name);
    }

    private String toJavaAccessor(String prefix, String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder method = new StringBuilder(prefix);
        if (name.charAt(0) == '_') {
            return method.append(name).toString();
        }
        if (name.length() == 1) {
            return method.append(name.toUpperCase()).toString();
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return method.append(name).toString();
        }
        if (Character.isUpperCase(name.charAt(1))) {
            return method.append(name).toString();
        }
        return method.append(StringUtils.capitalize((String)name)).toString();
    }

    private String toJavaName(String name, boolean firstLetterIsUpperCase) {
        name = name.toLowerCase();
        StringBuffer res = new StringBuffer();
        boolean nextIsUpperCase = firstLetterIsUpperCase;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (nextIsUpperCase) {
                c = Character.toUpperCase(c);
            }
            if (Character.isLetter(c)) {
                res.append(c);
                nextIsUpperCase = false;
                continue;
            }
            nextIsUpperCase = true;
        }
        return res.toString();
    }

    public String toJavaVar(String name) {
        return name;
    }

    public String getFilePath(String packageName, String simpleClassName, String extension) {
        packageName = packageName != null ? "/" + packageName.replace(".", "/") : "";
        return packageName + "/" + this.toFileName(simpleClassName) + "." + extension;
    }

    public String toFileName(String name) {
        return name.replaceAll("\\s", "");
    }

    public String resolveAttributeType(ObjectProperty attribute) {
        StringBuffer type = new StringBuffer("");
        if (attribute.isMultiple()) {
            if (attribute.getBag() != null && !"".equals(attribute.getBag())) {
                type.append(attribute.getBag());
            } else {
                type.append("java.util.List");
            }
            type.append("<");
        }
        type.append(attribute.getClassName());
        if (attribute.isMultiple()) {
            type.append(">");
        }
        return type.toString();
    }

    public String resolveAnnotationType(Annotation annotation) {
        StringBuffer type = new StringBuffer();
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        if (annotationDefinition == null) {
            logger.warn("Annotation definition for annotation: " + annotation + " is not defined.");
            return type.toString();
        }
        if (annotationDefinition.isMarker()) {
            return type.toString();
        }
        int memberCount = 0;
        for (AnnotationValuePairDefinition memberDefinition : annotationDefinition.getValuePairs()) {
            Object memberValue = annotation.getValue(memberDefinition.getName());
            if (memberValue == null) continue;
            if (memberCount == 0) {
                type.append("(");
            }
            if (memberCount > 0) {
                type.append(", ");
            }
            type.append(this.resolveMemberType(memberDefinition, memberValue));
            ++memberCount;
        }
        if (memberCount > 0) {
            type.append(")");
        }
        return type.toString();
    }

    public String resolveMemberType(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        StringBuffer type = new StringBuffer();
        type.append(valuePairDefinition.getName());
        type.append(" = ");
        type.append(this.resolveMemberTypeExpression(valuePairDefinition, value));
        return type.toString();
    }

    public String resolveMemberTypeExpression(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (valuePairDefinition.isArray()) {
            return this.resolveMemberTypeArrayValue(valuePairDefinition, value);
        }
        return this.resolveMemberTypeValue(valuePairDefinition, value);
    }

    public String resolveMemberTypeArrayValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        List values = (List)value;
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean isFirst = true;
        if (values.size() > 0) {
            for (Object listItem : values) {
                if (!isFirst) {
                    builder.append(", ");
                }
                builder.append(this.resolveMemberTypeValue(valuePairDefinition, listItem));
                isFirst = false;
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public String resolveMemberTypeValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        String typeValue = null;
        if (valuePairDefinition.isEnum()) {
            typeValue = this.resolveEnumValue(valuePairDefinition, value);
        } else if (valuePairDefinition.isString()) {
            typeValue = this.resolveStringValue(value);
        } else if (valuePairDefinition.isPrimitiveType()) {
            typeValue = this.resolvePrimitiveValue(valuePairDefinition, value);
        } else if (valuePairDefinition.isClass()) {
            typeValue = this.resolveClassValue(value);
        } else if (valuePairDefinition.isAnnotation() && value instanceof Annotation) {
            typeValue = "@" + NamingUtils.normalizeClassName(valuePairDefinition.getAnnotationDefinition().getClassName()) + this.resolveAnnotationType((Annotation)value);
        }
        return typeValue;
    }

    public String resolveEnumValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(NamingUtils.normalizeClassName(valuePairDefinition.getClassName()));
        builder.append(".");
        builder.append(value);
        return builder.toString();
    }

    public String resolveStringValue(Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(this.escapeStringForJavaCode(value != null ? value.toString() : null));
        builder.append("\"");
        return builder.toString();
    }

    public String resolvePrimitiveValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (Character.class.getName().equals(valuePairDefinition.getClassName())) {
            builder.append("'");
            builder.append(value.toString());
            builder.append("'");
        } else if (Long.class.getName().equals(valuePairDefinition.getClassName())) {
            builder.append(value.toString());
            builder.append("L");
        } else if (Float.class.getName().equals(valuePairDefinition.getClassName())) {
            builder.append(value.toString());
            builder.append("f");
        } else if (Double.class.getName().equals(valuePairDefinition.getClassName())) {
            builder.append(value.toString());
            builder.append("d");
        } else {
            builder.append(value.toString());
        }
        return builder.toString();
    }

    public String resolveClassValue(Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(value.toString());
        if (!builder.toString().endsWith(".class")) {
            builder.append(".class");
        }
        return builder.toString();
    }

    public String resolveSuperClassType(JavaClass javaClass) {
        StringBuffer type = new StringBuffer("");
        if (javaClass.getSuperClassName() != null && !"".equals(javaClass.getSuperClassName())) {
            type.append("extends ");
            type.append(javaClass.getSuperClassName());
        }
        return type.toString();
    }

    public String resolveImplementedInterfacesType(JavaClass javaClass) {
        StringBuilder type = new StringBuilder("implements " + Serializable.class.getName());
        if (javaClass.getInterfaces() != null) {
            for (String interfaceDefinition : javaClass.getInterfaces()) {
                if (interfaceDefinition.startsWith(Serializable.class.getName())) continue;
                type.append(", ").append(interfaceDefinition);
            }
        }
        return type.toString();
    }

    public boolean hasSuperClass(DataObject dataObject) {
        return dataObject != null && dataObject.getSuperClassName() != null && !"".equals(dataObject.getSuperClassName());
    }

    public int keyFieldsCount(DataObject dataObject) {
        int count = 0;
        if (dataObject != null && dataObject.getProperties() != null && !dataObject.getProperties().isEmpty()) {
            for (ObjectProperty prop : dataObject.getProperties()) {
                if (!DataModelUtils.isKeyField(prop)) continue;
                ++count;
            }
        }
        return count;
    }

    public int propertiesCount(DataObject dataObject) {
        return dataObject != null && dataObject.getProperties() != null ? dataObject.getProperties().size() : 0;
    }

    public int enabledForConstructorPropertiesCount(DataObject dataObject) {
        int count = 0;
        if (dataObject != null && dataObject.getProperties() != null && !dataObject.getProperties().isEmpty()) {
            for (ObjectProperty prop : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(prop)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean hasEquals(DataObject dataObject) {
        return this.keyFieldsCount(dataObject) > 0;
    }

    public boolean hasProperties(DataObject dataObject) {
        return this.propertiesCount(dataObject) > 0;
    }

    public boolean hasClassAnnotations(JavaClass javaClass) {
        return javaClass != null && javaClass.getAnnotations() != null && !javaClass.getAnnotations().isEmpty();
    }

    public boolean hasMethodAnnotations(Method method) {
        return method != null && method.getAnnotations() != null && !method.getAnnotations().isEmpty();
    }

    public String resolveMethodParameters(List<String> parameters) {
        StringBuilder builder = new StringBuilder("");
        Iterator<String> parameterIterator = parameters.iterator();
        int i = 1;
        while (parameterIterator.hasNext()) {
            builder.append(parameterIterator.next()).append(" o").append(i);
            if (parameterIterator.hasNext()) {
                builder.append(",");
            }
            ++i;
        }
        return builder.toString();
    }

    public String buildMethodReturnTypeString(Type returnType) {
        if (returnType == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(returnType.getName());
        this.buildTypeArgumentsString(returnType.getTypeArguments(), builder);
        return builder.toString();
    }

    public String buildMethodParameterString(List<Parameter> methodParameters) {
        if (methodParameters == null || methodParameters.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Parameter> iterator = methodParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            Type parameterType = parameter.getType();
            builder.append(parameterType.getName());
            this.buildTypeArgumentsString(parameter.getType().getTypeArguments(), builder);
            builder.append(" ");
            builder.append(parameter.getName());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private void buildTypeArgumentsString(List<Type> typeArguments, StringBuilder builder) {
        if (typeArguments == null || typeArguments.isEmpty()) {
            return;
        }
        builder.append("<");
        Iterator<Type> iterator = typeArguments.iterator();
        while (iterator.hasNext()) {
            Type argument = iterator.next();
            builder.append(argument.getName());
            this.buildTypeArgumentsString(argument.getTypeArguments(), builder);
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(">");
    }

    public String resolveEquals(DataObject dataObject, String indent) {
        StringBuilder head = new StringBuilder();
        head.append(indent + "@Override" + EOL);
        head.append(indent + "public boolean equals(Object o) {" + EOL);
        head.append(indent + "    " + "if (this == o) return true;" + EOL);
        head.append(indent + "    " + "if (o == null || getClass() != o.getClass()) return false;" + EOL);
        head.append(indent + "    " + dataObject.getClassName() + " that = (" + dataObject.getClassName() + ")o;" + EOL);
        StringBuilder end = new StringBuilder();
        end.append(indent + "}");
        StringBuilder sb = new StringBuilder();
        List<ObjectProperty> props = DataModelUtils.filterKeyFields(dataObject);
        props = DataModelUtils.sortByFileOrder(props);
        boolean hasTerms = false;
        if (props != null && props.size() > 0) {
            for (ObjectProperty prop : props) {
                String _propName = this.toJavaVar(prop.getName());
                if (!DataModelUtils.isKeyField(prop)) continue;
                if (NamingUtils.isPrimitiveTypeId(prop.getClassName())) {
                    sb.append(indent + "    ");
                    this.addEqualsTermForPrimitive(sb, _propName, prop.getClassName());
                } else {
                    sb.append(indent + "    " + "if (");
                    sb.append(_propName).append(" != null ? !").append(_propName).append(".equals(that.").append(_propName).append(")");
                    sb.append(" : that.").append(_propName).append(" != null").append(") return false;");
                }
                sb.append(EOL);
                hasTerms = true;
            }
        }
        if (hasTerms) {
            sb.append(indent + "    " + "return true;" + EOL);
            head.append((CharSequence)sb);
            head.append((CharSequence)end);
            return head.toString();
        }
        return "";
    }

    public String resolveEquals(DataObject dataObject) {
        return this.resolveEquals(dataObject, "");
    }

    private void addEqualsTermForPrimitive(StringBuilder sb, String _propName, String primitive) {
        if ("double".equals(primitive)) {
            sb.append("if (Double.compare(that.").append(_propName).append(", ").append(_propName).append(") != 0) return false;");
        } else if ("float".equals(primitive)) {
            sb.append("if (Float.compare(that.").append(_propName).append(", ").append(_propName).append(") != 0) return false;");
        } else {
            sb.append("if (").append(_propName).append(" != that.").append(_propName).append(")").append(" return false;");
        }
    }

    public String resolveHashCode(DataObject dataObject, String indent) {
        StringBuilder head = new StringBuilder();
        head.append(indent + "@Override" + EOL);
        head.append(indent + "public int hashCode() {" + EOL);
        head.append(indent + "    " + "int result = 17;" + EOL);
        StringBuilder end = new StringBuilder();
        end.append(indent + "}");
        StringBuilder sb = new StringBuilder();
        List<ObjectProperty> props = DataModelUtils.filterKeyFields(dataObject);
        props = DataModelUtils.sortByFileOrder(props);
        boolean hasTerms = false;
        if (props != null && props.size() > 0) {
            for (ObjectProperty prop : props) {
                String _propName = this.toJavaVar(prop.getName());
                if (!DataModelUtils.isKeyField(prop)) continue;
                if (NamingUtils.isPrimitiveTypeId(prop.getClassName())) {
                    sb.append(indent + "    ");
                    this.addHashCodeTermForPrimitive(sb, _propName, prop.getClassName());
                } else {
                    sb.append(indent + "    " + "result = 31 * result + (").append(_propName).append(" != null ? ").append(_propName).append(".hashCode() : 0);");
                }
                sb.append(EOL);
                hasTerms = true;
            }
        }
        if (hasTerms) {
            sb.append(indent + "    " + "return result;" + EOL);
            head.append((CharSequence)sb);
            head.append((CharSequence)end);
            return head.toString();
        }
        return "";
    }

    public String resolveHashCode(DataObject dataObject) {
        return this.resolveHashCode(dataObject, "");
    }

    private void addHashCodeTermForPrimitive(StringBuilder sb, String _propName, String primitive) {
        if ("byte".equals(primitive) || "char".equals(primitive) || "short".equals(primitive)) {
            sb.append("result = 31 * result + (int) ").append(_propName).append(";");
        } else if ("boolean".equals(primitive)) {
            sb.append("result = 31 * result + (").append(_propName).append(" ? 1 : 0);");
        } else if ("long".equals(primitive)) {
            sb.append("result = 31 * result + (int) (").append(_propName).append(" ^ (").append(_propName).append(" >>> 32));");
        } else if ("double".equals(primitive)) {
            String temp = "Double.doubleToLongBits(" + _propName + ")";
            sb.append("result = 31 * result + (int) (" + temp + " ^ (" + temp + " >>> 32));");
        } else if ("float".equals(primitive)) {
            sb.append("result = 31 * result + (").append(_propName).append(" != +0.0f ? Float.floatToIntBits(").append(_propName).append(") : 0);");
        } else {
            sb.append("result = 31 * result + ").append(_propName).append(";");
        }
    }

    public String resolveVisibility(Method method) {
        Visibility visibility = method.getVisibilty();
        if (visibility == null) {
            return "";
        }
        switch (visibility) {
            case PUBLIC: {
                return "public";
            }
            case PROTECTED: {
                return "protected";
            }
            case PACKAGE_PRIVATE: {
                return "";
            }
            case PRIVATE: {
                return "private";
            }
        }
        throw new IllegalArgumentException("Visibility type '" + (Object)((Object)visibility) + "' is not supported.");
    }

    public String resolveAllFieldsConstructor(DataObject dataObject, String indent) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(property)) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < 120) {
                return this.resolveConstructor(dataObject, DataModelUtils.sortByPosition(this.sortByName(sortedProperties)), indent);
            }
        }
        return "";
    }

    public String resolveAllFieldsConstructor(DataObject dataObject) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(property)) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < 120) {
                return this.resolveConstructor2(dataObject, DataModelUtils.sortByFileOrder(sortedProperties), "    ");
            }
        }
        return "";
    }

    public String resolveKeyFieldsConstructor(DataObject dataObject, String indent) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(property) || !DataModelUtils.isKeyField(property)) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < dataObject.getProperties().size()) {
                return this.resolveConstructor(dataObject, DataModelUtils.sortByPosition(this.sortByName(sortedProperties)), indent);
            }
        }
        return "";
    }

    public String resolveKeyFieldsConstructor(DataObject dataObject) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(property) || !DataModelUtils.isKeyField(property)) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < 120) {
                return this.resolveConstructor2(dataObject, DataModelUtils.sortByFileOrder(sortedProperties), "    ");
            }
        }
        return "";
    }

    public String resolvePositionFieldsConstructor(DataObject dataObject) {
        if (!dataObject.getProperties().isEmpty()) {
            ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelUtils.isAssignable(property) || !DataModelUtils.isPositionField(property)) continue;
                sortedProperties.add(property);
            }
            if (sortedProperties.size() > 0 && sortedProperties.size() < 120) {
                return this.resolveConstructor2(dataObject, DataModelUtils.sortByPosition(sortedProperties), "    ");
            }
        }
        return "";
    }

    public List<Annotation> sortAnnotationsByName(List<Annotation> annotations) {
        Collections.sort(annotations, new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                String key1 = o1.getClassName();
                String key2 = o2.getClassName();
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                if (key1 == null && key2 != null) {
                    return -1;
                }
                return 1;
            }
        });
        return annotations;
    }

    public List<Annotation> sortedAnnotations(HasAnnotations hasAnnotations) {
        ArrayList<Annotation> sortedAnnotations = new ArrayList<Annotation>();
        if (hasAnnotations != null && !hasAnnotations.getAnnotations().isEmpty()) {
            sortedAnnotations.addAll(hasAnnotations.getAnnotations());
        }
        return this.sortAnnotationsByName(sortedAnnotations);
    }

    public List<ObjectProperty> sortedProperties(DataObject dataObject) {
        ArrayList<ObjectProperty> sortedProperties = new ArrayList<ObjectProperty>();
        if (dataObject != null && !dataObject.getProperties().isEmpty()) {
            sortedProperties.addAll(dataObject.getProperties());
        }
        return this.sortByName(sortedProperties);
    }

    public List<ObjectProperty> sortByName(List<ObjectProperty> properties) {
        Collections.sort(properties, new Comparator<ObjectProperty>(){

            @Override
            public int compare(ObjectProperty o1, ObjectProperty o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                String key1 = o1.getName();
                String key2 = o2.getName();
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                if (key1 == null && key2 != null) {
                    return -1;
                }
                return 1;
            }
        });
        return properties;
    }

    public String resolveConstructor(DataObject dataObject, List<ObjectProperty> properties, String indent) {
        StringBuilder head = new StringBuilder();
        StringBuilder body = new StringBuilder();
        head.append(indent + "public " + dataObject.getName() + "(");
        if (properties != null && properties.size() > 0) {
            boolean isFirst = true;
            for (ObjectProperty property : properties) {
                if (!isFirst) {
                    head.append(", ");
                    body.append(EOL);
                }
                String propertyName = this.toJavaVar(property.getName());
                head.append(this.resolveAttributeType(property));
                head.append(" ");
                head.append(propertyName);
                body.append(indent);
                body.append(indent);
                body.append("this.");
                body.append(propertyName);
                body.append(" = ");
                body.append(propertyName);
                body.append(";");
                isFirst = false;
            }
            body.append(EOL);
        }
        head.append(") {" + EOL);
        head.append((CharSequence)body);
        head.append(indent + "}");
        return head.toString();
    }

    public String resolveConstructor2(DataObject dataObject, List<ObjectProperty> properties, String indent) {
        StringBuilder head = new StringBuilder();
        StringBuilder body = new StringBuilder();
        head.append("public " + dataObject.getName() + "(");
        if (properties != null && properties.size() > 0) {
            boolean isFirst = true;
            for (ObjectProperty property : properties) {
                if (!isFirst) {
                    head.append(", ");
                    body.append(EOL);
                }
                String propertyName = this.toJavaVar(property.getName());
                head.append(this.resolveAttributeType(property));
                head.append(" ");
                head.append(propertyName);
                body.append(indent);
                body.append("this.");
                body.append(propertyName);
                body.append(" = ");
                body.append(propertyName);
                body.append(";");
                isFirst = false;
            }
            body.append(EOL);
        }
        head.append(") {" + EOL);
        head.append((CharSequence)body);
        head.append("}");
        return head.toString();
    }

    public String escapeStringForJavaCode(String value) {
        if (value == null) {
            return value;
        }
        return StringEscapeUtils.escapeJava(value);
    }

    public String fileHashEmptyTag() {
        return FileHashingUtils.getFileHashEmptyTag();
    }

    public String indent(String source) throws Exception {
        return START_INDENT + GenerationEngine.indentLines(source, "    ");
    }

    public String indentFieldAnnotation(String source) throws Exception {
        return "\n    " + source;
    }

    public String indentClassAnnotation(String source) throws Exception {
        return "\n" + source;
    }
}

