/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.services.datamodeller.driver.FilterHolder;
import org.kie.workbench.common.services.datamodeller.driver.MethodFilter;
import org.kie.workbench.common.services.datamodeller.driver.NestedClassFilter;
import org.kie.workbench.common.services.datamodeller.driver.SourceFilter;

@ApplicationScoped
public class FilterHolderImpl
implements FilterHolder {
    @Inject
    @Any
    private Instance<SourceFilter> sourceFiltersInstance;
    @Inject
    @Any
    private Instance<NestedClassFilter> nestedClassFiltersInstance;
    @Inject
    @Any
    private Instance<MethodFilter> methodFiltersInstance;
    private Collection<SourceFilter> sourceFilters;
    private Collection<NestedClassFilter> nestedClassFilters;
    private Collection<MethodFilter> methodFilters;

    @PostConstruct
    private void init() {
        this.sourceFilters = StreamSupport.stream(this.sourceFiltersInstance.spliterator(), false).collect(Collectors.toList());
        this.nestedClassFilters = StreamSupport.stream(this.nestedClassFiltersInstance.spliterator(), false).collect(Collectors.toList());
        this.methodFilters = StreamSupport.stream(this.methodFiltersInstance.spliterator(), false).collect(Collectors.toList());
    }

    @PreDestroy
    private void tearDown() {
        this.sourceFilters.forEach(filter -> this.sourceFiltersInstance.destroy(filter));
        this.sourceFilters.clear();
        this.nestedClassFilters.forEach(filter -> this.nestedClassFiltersInstance.destroy(filter));
        this.nestedClassFilters.clear();
        this.methodFilters.forEach(filter -> this.methodFiltersInstance.destroy(filter));
        this.methodFilters.clear();
    }

    @Override
    public Collection<SourceFilter> getSourceFilters() {
        return this.sourceFilters;
    }

    @Override
    public Collection<NestedClassFilter> getNestedClassFilters() {
        return this.nestedClassFilters;
    }

    @Override
    public Collection<MethodFilter> getMethodFilters() {
        return this.methodFilters;
    }
}

