/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.MethodDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifiersContainerDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.VariableDeclarationDescr;

public class ClassDescr
extends ModifiersContainerDescr {
    public ClassDescr() {
        super(ElementDescriptor.ElementType.CLASS);
    }

    public ClassDescr(String text, int start, int line, int position) {
        this(text, start, -1, line, position);
    }

    public ClassDescr(String text, int start, int stop) {
        this(text, start, stop, -1, -1);
    }

    public ClassDescr(String text, int start, int stop, int line, int position) {
        super(ElementDescriptor.ElementType.CLASS, text, start, stop, line, position);
    }

    public String getName() {
        return this.getIdentifier() != null ? this.getIdentifier().getIdentifier() : null;
    }

    public IdentifierDescr getIdentifier() {
        return (IdentifierDescr)this.getElements().getFirst(ElementDescriptor.ElementType.IDENTIFIER);
    }

    public ClassDescr setIdentifier(IdentifierDescr identifier) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.IDENTIFIER);
        this.getElements().add(identifier);
        return this;
    }

    public void addMember(ElementDescriptor member) {
        this.getElements().add(member);
    }

    public List<ElementDescriptor> getMembers() {
        return this.getElements();
    }

    public void addField(FieldDescr fieldDescr) {
        int index = this.getElements().lastIndexOf(ElementDescriptor.ElementType.FIELD);
        if (index < 0) {
            index = this.getElements().indexOf(ElementDescriptor.ElementType.JAVA_LBRACE);
        }
        this.getElements().add(index + 1, fieldDescr);
    }

    public void addMethod(MethodDescr methodDescr) {
        int index = this.getElements().lastIndexOf(ElementDescriptor.ElementType.METHOD);
        if (index < 0 && (index = this.getElements().lastIndexOf(ElementDescriptor.ElementType.FIELD)) < 0) {
            index = this.getElements().indexOf(ElementDescriptor.ElementType.JAVA_LBRACE);
        }
        this.getElements().add(index + 1, methodDescr);
    }

    public List<MethodDescr> getMethods() {
        ArrayList<MethodDescr> methods = new ArrayList<MethodDescr>();
        for (ElementDescriptor member : this.getElements().getElementsByType(ElementDescriptor.ElementType.METHOD)) {
            methods.add((MethodDescr)member);
        }
        return methods;
    }

    public MethodDescr getMethod(String methodIdentifier) {
        if (methodIdentifier == null) {
            return null;
        }
        List<MethodDescr> methods = this.getMethods();
        for (MethodDescr method : methods) {
            IdentifierDescr identifier = method.getIdentifier();
            if (identifier == null || !methodIdentifier.equals(identifier.getIdentifier())) continue;
            return method;
        }
        return null;
    }

    public List<MethodDescr> getConstructors() {
        List<MethodDescr> allMethods = this.getMethods();
        ArrayList<MethodDescr> constructors = new ArrayList<MethodDescr>();
        for (MethodDescr method : allMethods) {
            if (!method.isConstructor()) continue;
            constructors.add(method);
        }
        return constructors;
    }

    public List<FieldDescr> getFields() {
        ArrayList<FieldDescr> fields = new ArrayList<FieldDescr>();
        for (ElementDescriptor member : this.getElements().getElementsByType(ElementDescriptor.ElementType.FIELD)) {
            fields.add((FieldDescr)member);
        }
        return fields;
    }

    public FieldDescr getField(String name) {
        if (name == null) {
            return null;
        }
        List<FieldDescr> fields = this.getFields();
        for (FieldDescr field : fields) {
            if (field.getVariableDeclaration(name) == null) continue;
            return field;
        }
        return null;
    }

    public boolean removeField(FieldDescr field) {
        return this.getElements().remove(field);
    }

    public boolean removeField(String name) {
        FieldDescr field = this.getField(name);
        boolean result = false;
        if (field != null) {
            if (field.getVariableDeclarations().size() <= 1) {
                result = this.getElements().remove(field);
            } else {
                VariableDeclarationDescr variable = field.getVariableDeclaration(name);
                boolean bl = result = variable != null ? field.removeVariableDeclaration(variable) : false;
                if (result && (variable = field.getVariableDeclarations().get(0)).getStartComma() != null) {
                    variable.getElements().remove(variable.getStartComma());
                }
            }
        }
        return result;
    }

    public boolean removeMethod(String name) {
        List<MethodDescr> methods = this.getMethods();
        boolean result = false;
        if (methods != null) {
            for (MethodDescr methodDescr : methods) {
                IdentifierDescr identifier = methodDescr.getIdentifier();
                if (identifier == null || !name.equals(identifier.getIdentifier()) || !this.getElements().remove(methodDescr)) continue;
                result = true;
            }
        }
        return result;
    }

    public JavaTokenDescr getClassToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_CLASS);
    }

    public void setClassToken(JavaTokenDescr classToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_CLASS);
        this.getElements().add(classToken);
    }

    public JavaTokenDescr getExtendsToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_EXTENDS);
    }

    public void setExtendsToken(JavaTokenDescr extendsToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_EXTENDS);
        this.getElements().add(extendsToken);
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    public TypeDescr getSuperClass() {
        return (TypeDescr)this.getElements().getFirst(ElementDescriptor.ElementType.TYPE);
    }

    public void setSuperClass(TypeDescr superClass) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.TYPE);
        this.getElements().add(superClass);
    }

    public JavaTokenDescr getImplementsToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_IMPLEMENTS);
    }

    public void setImplementsToken(JavaTokenDescr implementsToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_IMPLEMENTS);
        this.getElements().add(implementsToken);
    }

    public JavaTokenDescr getBodyStartBrace() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_LBRACE);
    }

    public void setBodyStartBrace(JavaTokenDescr bodyStart) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_LBRACE);
        this.getElements().add(bodyStart);
    }

    public JavaTokenDescr getBodyStopBrace() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_RBRACE);
    }

    public void setBodyStopBrace(JavaTokenDescr bodyStop) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_RBRACE);
        this.getElements().add(bodyStop);
    }
}

