/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.HasType;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifiersContainerDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.VariableDeclarationDescr;

public class FieldDescr
extends ModifiersContainerDescr
implements HasType {
    public FieldDescr() {
        super(ElementDescriptor.ElementType.FIELD);
    }

    public FieldDescr(String text, int start, int end) {
        this(text, start, end, -1, -1);
    }

    public FieldDescr(String text, int start, int stop, int line, int position) {
        super(ElementDescriptor.ElementType.FIELD, text, start, stop, line, position);
    }

    @Override
    public TypeDescr getType() {
        return (TypeDescr)this.getElements().getFirst(ElementDescriptor.ElementType.TYPE);
    }

    @Override
    public FieldDescr setType(TypeDescr type) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.TYPE);
        this.getElements().add(type);
        return this;
    }

    public List<VariableDeclarationDescr> getVariableDeclarations() {
        ArrayList<VariableDeclarationDescr> variableDeclarations = new ArrayList<VariableDeclarationDescr>();
        for (ElementDescriptor member : this.getElements().getElementsByType(ElementDescriptor.ElementType.VARIABLE)) {
            variableDeclarations.add((VariableDeclarationDescr)member);
        }
        return variableDeclarations;
    }

    public FieldDescr addVariableDeclaration(VariableDeclarationDescr variableDeclarationDescr) {
        this.getElements().add(variableDeclarationDescr);
        return this;
    }

    public boolean removeVariableDeclaration(VariableDeclarationDescr variableDeclarationDescr) {
        return this.getElements().remove(variableDeclarationDescr);
    }

    public JavaTokenDescr getEndSemiColon() {
        return (JavaTokenDescr)this.getElements().getLast(ElementDescriptor.ElementType.JAVA_SEMI_COLON);
    }

    public FieldDescr setEndSemiColon(JavaTokenDescr element) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_SEMI_COLON);
        this.getElements().add(element);
        return this;
    }

    public VariableDeclarationDescr getVariableDeclaration(String name) {
        if (name == null) {
            return null;
        }
        for (VariableDeclarationDescr variable : this.getVariableDeclarations()) {
            IdentifierDescr identifier = variable.getIdentifier();
            if (identifier == null || !name.equals(identifier.getIdentifier())) continue;
            return variable;
        }
        return null;
    }

    public FieldDescr removeVariableDeclaration(String name) {
        VariableDeclarationDescr variableDeclarationDescr = this.getVariableDeclaration(name);
        if (variableDeclarationDescr != null) {
            this.removeVariableDeclaration(variableDeclarationDescr);
        }
        return this;
    }
}

