/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.common.util.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredServerKeyVerifier
implements ServerKeyVerifier {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    final PublicKey requiredKey;

    public RequiredServerKeyVerifier(PublicKey requiredKey) {
        this.requiredKey = requiredKey;
    }

    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        if (this.requiredKey.equals(serverKey)) {
            this.log.debug("Server at {} presented expected key: {}", (Object)remoteAddress, (Object)BufferUtils.printHex(serverKey.getEncoded()));
            return true;
        }
        this.log.error("Server at {} presented wrong key: {}", (Object)remoteAddress, (Object)BufferUtils.printHex(serverKey.getEncoded()));
        return false;
    }
}

