/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;

public class SocialFile {
    private final Path path;
    private final Gson gson;
    private final String JSON_SEPARATOR = "01";
    private final IOService ioService;
    private byte[] JSON_SEPARATOR_BYTES;
    private SeekableByteChannel reader;
    private long currentCursorReadPosition;
    private ByteBuffer byteBufferSize;

    public SocialFile(Path path, IOService ioService, Gson gson) {
        try {
            this.JSON_SEPARATOR_BYTES = Hex.decodeHex((char[])"01".toCharArray());
        }
        catch (DecoderException e) {
            throw new ErrorReadingFile();
        }
        this.byteBufferSize = ByteBuffer.allocate("a".getBytes().length);
        this.path = path;
        this.gson = gson;
        this.currentCursorReadPosition = -1L;
        this.ioService = ioService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<SocialActivitiesEvent> events) throws IOException {
        try {
            this.ioService.startBatch(this.path.getFileSystem());
            SeekableByteChannel sbc = this.ioService.newByteChannel(this.path, new OpenOption[0]);
            for (SocialActivitiesEvent event : events) {
                String json = this.gson.toJson((Object)event);
                this.writeJson(json, sbc);
                this.writeSeparator(sbc);
                this.writeJsonSize(sbc, json);
                this.writeSeparator(sbc);
            }
            sbc.close();
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void writeJsonSize(SeekableByteChannel sbc, String json) throws IOException {
        String jsonLenght = String.valueOf(json.getBytes().length);
        ByteBuffer bfSrc = ByteBuffer.wrap(jsonLenght.getBytes());
        sbc.write(bfSrc);
    }

    private void writeSeparator(SeekableByteChannel sbc) throws IOException {
        ByteBuffer bfSrc = ByteBuffer.wrap(this.JSON_SEPARATOR_BYTES);
        sbc.write(bfSrc);
    }

    private void writeJson(String json, SeekableByteChannel sbc) throws IOException {
        ByteBuffer bfSrc = ByteBuffer.wrap(json.getBytes());
        sbc.write(bfSrc);
    }

    public void prepareForReading() throws IOException {
        this.reader = this.ioService.newByteChannel(this.path, new OpenOption[]{StandardOpenOption.READ});
        this.currentCursorReadPosition = this.reader.size() - 1L;
    }

    private void reverseSearchForSeparatorPosition() throws IOException {
        if (this.reader.size() > 0L) {
            this.reader.position(this.currentCursorReadPosition);
            this.reader.read(this.byteBufferSize);
            this.byteBufferSize.flip();
            String s = new String(this.byteBufferSize.array());
            if (!this.lookforSeparator(this.byteBufferSize.array())) {
                --this.currentCursorReadPosition;
                this.reverseSearchForSeparatorPosition();
            }
        }
    }

    public List<SocialActivitiesEvent> readSocialEvents(Integer numberOfEvents) {
        ArrayList<SocialActivitiesEvent> events = new ArrayList<SocialActivitiesEvent>();
        if (this.ioService.exists(this.path)) {
            for (int i = 0; i < numberOfEvents; ++i) {
                try {
                    String json = this.readNextSocialEventJSON();
                    SocialActivitiesEvent event = (SocialActivitiesEvent)this.gson.fromJson(json, SocialActivitiesEvent.class);
                    events.add(event);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return events;
    }

    private String readNextSocialEventJSON() throws IOException {
        if (this.startReading()) {
            this.prepareForReading();
        }
        if (this.reader.size() <= 0L) {
            throw new EmptySocialFile();
        }
        this.reverseSearchForSeparatorPosition();
        StringBuilder numberOfBytesNextJSON = this.getNumberOfBytesOfJSON();
        if (StringUtils.isNumeric((CharSequence)numberOfBytesNextJSON.toString())) {
            return this.extractJSON(numberOfBytesNextJSON);
        }
        return this.readNextSocialEventJSON();
    }

    private String extractJSON(StringBuilder numberOfBytesNextJSON) throws IOException {
        Integer numberOfBytes = this.getNumberOfBytesToReadJSON(numberOfBytesNextJSON);
        this.putCursorInRightPosition(numberOfBytes);
        return this.readJSON(numberOfBytes);
    }

    private String readJSON(Integer numberOfBytes) throws IOException {
        ByteBuffer jsonByteBuffer = ByteBuffer.allocate(numberOfBytes);
        StringBuilder extractedJSON = new StringBuilder();
        while (this.reader.read(jsonByteBuffer) > 0) {
            extractedJSON.append(new String(jsonByteBuffer.array()));
        }
        return extractedJSON.toString();
    }

    private void putCursorInRightPosition(Integer numberOfBytes) throws IOException {
        this.currentCursorReadPosition -= (long)numberOfBytes.intValue();
        this.reader.position(this.currentCursorReadPosition);
    }

    private Integer getNumberOfBytesToReadJSON(StringBuilder numberOfBytesNextJSON) {
        Integer numberOfBytes = new Integer(numberOfBytesNextJSON.toString());
        return numberOfBytes;
    }

    private StringBuilder getNumberOfBytesOfJSON() throws IOException {
        --this.currentCursorReadPosition;
        this.reader.position(this.currentCursorReadPosition);
        StringBuilder numberOfBytesNextJSON = new StringBuilder();
        if (this.thereIsSomethingToRead(this.reader, this.byteBufferSize)) {
            this.byteBufferSize.flip();
            if (!this.lookforSeparator(this.byteBufferSize.array())) {
                String charRead = new String(this.byteBufferSize.array());
                numberOfBytesNextJSON.append(charRead);
                --this.currentCursorReadPosition;
                this.reader.position(this.currentCursorReadPosition);
                while (this.thereIsSomethingToRead(this.reader, this.byteBufferSize)) {
                    this.byteBufferSize.flip();
                    charRead = new String(this.byteBufferSize.array());
                    if (this.lookforSeparator(this.byteBufferSize.array())) break;
                    numberOfBytesNextJSON.append(charRead);
                    this.byteBufferSize.clear();
                    --this.currentCursorReadPosition;
                    this.reader.position(this.currentCursorReadPosition);
                }
            }
        }
        numberOfBytesNextJSON = numberOfBytesNextJSON.reverse();
        return numberOfBytesNextJSON;
    }

    private boolean startReading() {
        return this.reader == null || this.currentCursorReadPosition <= 0L;
    }

    private boolean thereIsSomethingToRead(SeekableByteChannel sbc, ByteBuffer bf) throws IOException {
        int i = sbc.read(bf);
        return i > 0;
    }

    private boolean lookforSeparator(byte[] charRead) {
        String hexString = Hex.encodeHexString((byte[])charRead);
        return hexString.equalsIgnoreCase("01");
    }

    private class ErrorReadingFile
    extends RuntimeException {
        private ErrorReadingFile() {
        }
    }

    private class EmptySocialFile
    extends RuntimeException {
        private EmptySocialFile() {
        }
    }
}

