/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.ext.uberfire.social.activities.adapters.CommandTimelineFilter;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.repository.SocialUserRepository;
import org.ext.uberfire.social.activities.service.SocialAdapter;
import org.ext.uberfire.social.activities.service.SocialPredicate;
import org.ext.uberfire.social.activities.service.SocialRouterAPI;
import org.ext.uberfire.social.activities.service.SocialTimeLineRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class SocialTimeLineRepository
implements SocialTimeLineRepositoryAPI {
    @Inject
    @Named(value="socialTimelinePersistence")
    SocialTimelinePersistenceAPI socialTimelinePersistence;
    @Inject
    SocialUserRepository socialUserRepository;
    @Inject
    SocialRouterAPI socialRouterAPI;
    @Inject
    CommandTimelineFilter commandTimelineFilter;

    public List<SocialActivitiesEvent> getLastEventTimeline(String adapterName) {
        return this.getLastEventTimeline(adapterName, new HashMap());
    }

    public List<SocialActivitiesEvent> getLastEventTimeline(String adapterName, Map commandsMap) {
        SocialAdapter socialAdapter = this.socialRouterAPI.getSocialAdapter(adapterName);
        return this.getLastEventTimeline(socialAdapter, commandsMap);
    }

    public List<SocialActivitiesEvent> getLastEventTimeline(SocialAdapter type, Map commandsMap) {
        List<SocialActivitiesEvent> socialActivitiesEvents = this.socialTimelinePersistence.getLastEvents(type.socialEventType());
        if (socialActivitiesEvents == null) {
            socialActivitiesEvents = new ArrayList<SocialActivitiesEvent>();
        }
        if (this.shouldExecuteAdapters(commandsMap, socialActivitiesEvents)) {
            socialActivitiesEvents = this.commandTimelineFilter.executeTypeCommandsOn(type, commandsMap, socialActivitiesEvents);
        }
        this.sortListByDate(socialActivitiesEvents);
        return socialActivitiesEvents;
    }

    private void sortListByDate(List<SocialActivitiesEvent> socialActivitiesEvents) {
        Collections.sort(socialActivitiesEvents, new Comparator<SocialActivitiesEvent>(){

            @Override
            public int compare(SocialActivitiesEvent o1, SocialActivitiesEvent o2) {
                return o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
    }

    public void saveTypeEvent(SocialActivitiesEvent event) {
        this.socialTimelinePersistence.persist(event);
    }

    public void saveUserEvent(SocialActivitiesEvent event) {
        SocialUser eventUser = event.getSocialUser();
        this.addEventToTimeline(event, eventUser);
        for (String followerName : eventUser.getFollowersName()) {
            SocialUser follower = this.socialUserRepository.findSocialUser(followerName);
            this.addEventToTimeline(event, follower);
        }
    }

    private void addEventToTimeline(SocialActivitiesEvent event, SocialUser user) {
        this.socialTimelinePersistence.persist(user, event);
    }

    public Integer numberOfPages(SocialEventType type) {
        return this.socialTimelinePersistence.numberOfPages(type);
    }

    public List<SocialActivitiesEvent> getLastUserTimeline(SocialUser user) {
        return this.getLastUserTimeline(user, new HashMap());
    }

    public List<SocialActivitiesEvent> getLastUserTimeline(SocialUser user, SocialPredicate<SocialActivitiesEvent> predicate) {
        ArrayList<SocialActivitiesEvent> filteredList = new ArrayList<SocialActivitiesEvent>();
        List<SocialActivitiesEvent> lastUserTimeline = this.getLastUserTimeline(user, new HashMap());
        for (SocialActivitiesEvent socialActivitiesEvent : lastUserTimeline) {
            if (!predicate.test((Object)socialActivitiesEvent)) continue;
            filteredList.add(socialActivitiesEvent);
        }
        return filteredList;
    }

    public List<SocialActivitiesEvent> getLastUserTimeline(SocialUser user, Map commandsMap) {
        List<SocialActivitiesEvent> userEvents = this.socialTimelinePersistence.getLastEvents(user);
        if (userEvents == null) {
            userEvents = new ArrayList<SocialActivitiesEvent>();
        }
        if (this.shouldExecuteAdapters(commandsMap, userEvents)) {
            userEvents = this.commandTimelineFilter.executeUserCommandsOn(userEvents, commandsMap);
        }
        this.sortListByDate(userEvents);
        return userEvents;
    }

    private boolean shouldExecuteAdapters(Map commandsMap, List<SocialActivitiesEvent> events) {
        return !events.isEmpty() && commandsMap.size() > 0;
    }
}

